/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.config2brigadier.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.samo_lego.config2brigadier.IBrigadierConfigurator;

public record ConfigFieldList(Field parentField, Object parent, List<Field> booleans, List<Field> integers, List<Field> floats, List<Field> doubles, List<Field> objects, List<ConfigFieldList> nestedFields) {
    public static ConfigFieldList populateFields(@Nullable Field parentField, Object parent, IBrigadierConfigurator config) {
        ArrayList<Field> bools = new ArrayList<Field>();
        ArrayList<Field> ints = new ArrayList<Field>();
        ArrayList<Field> floats = new ArrayList<Field>();
        ArrayList<Field> doubles = new ArrayList<Field>();
        ArrayList<Field> objects = new ArrayList<Field>();
        ArrayList<ConfigFieldList> nested = new ArrayList<ConfigFieldList>();
        for (Field attribute : parent.getClass().getFields()) {
            Class<?> type = attribute.getType();
            if (config.shouldExclude(attribute)) continue;
            if (type.equals(Boolean.TYPE)) {
                bools.add(attribute);
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                ints.add(attribute);
                continue;
            }
            if (type.equals(Float.TYPE)) {
                floats.add(attribute);
                continue;
            }
            if (type.equals(Double.TYPE)) {
                doubles.add(attribute);
                continue;
            }
            if (type.isMemberClass()) {
                try {
                    attribute.setAccessible(true);
                    Object childAttribute = attribute.get(parent);
                    nested.add(ConfigFieldList.populateFields(attribute, childAttribute, config));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            objects.add(attribute);
        }
        return new ConfigFieldList(parentField, parent, Collections.unmodifiableList(bools), Collections.unmodifiableList(ints), Collections.unmodifiableList(floats), Collections.unmodifiableList(doubles), Collections.unmodifiableList(objects), Collections.unmodifiableList(nested));
    }
}

