/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.config2brigadier;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.samo_lego.config2brigadier.IBrigadierConfigurator;
import org.samo_lego.config2brigadier.util.TranslatedText;

public class Config2Brigadier {
    public static final String MOD_ID = "config2brigadier";
    public static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().create();

    public static void init() {
        LogManager.getLogger((String)MOD_ID).info("Loaded C2B lib.");
        TranslatedText.setLang("en_us");
    }

    public static <T extends IBrigadierConfigurator> T loadConfigFile(File file, Class<T> clazz, Supplier<T> fallbackConstructor) {
        IBrigadierConfigurator config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (IBrigadierConfigurator)GSON.fromJson((Reader)fileReader, clazz);
            }
            catch (IOException e) {
                throw new RuntimeException("config2brigadier Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = (IBrigadierConfigurator)fallbackConstructor.get();
        }
        config.writeToFile(file);
        return (T)config;
    }
}

