/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import io.github.fabricators_of_create.porting_lib.transfer.internal.cache.EmptyFluidLookupCache;
import io.github.fabricators_of_create.porting_lib.transfer.internal.cache.EmptyItemLookupCache;
import io.github.fabricators_of_create.porting_lib.transfer.internal.extensions.LevelExtensions;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class StorageProvider<T>
implements Function<class_2350, Storage<T>> {
    public final BlockApiLookup<Storage<T>, class_2350> lookup;
    public final class_1937 level;
    public final class_2338 pos;

    protected StorageProvider(BlockApiLookup<Storage<T>, class_2350> lookup, class_1937 level, class_2338 pos) {
        this.lookup = lookup;
        this.level = level;
        this.pos = pos;
    }

    @Nullable
    public Storage<T> get(class_2350 direction) {
        return (Storage)this.lookup.find(this.level, this.pos, (Object)direction);
    }

    @Nullable
    public class_2586 findBlockEntity() {
        return this.level.method_8321(this.pos);
    }

    public class_2680 findBlockState() {
        return this.level.method_8320(this.pos);
    }

    public StorageProvider<T> filter(BiPredicate<StorageProvider<T>, Storage<T>> filter) {
        return new FilteringStorageProvider<T>(this, filter);
    }

    @Override
    @Nullable
    public Storage<T> apply(class_2350 direction) {
        return this.get(direction);
    }

    public static StorageProvider<FluidVariant> createForFluids(class_1937 level, class_2338 pos) {
        BlockApiCache<Storage<FluidVariant>, class_2350> cache = ((LevelExtensions)level).port_lib$getFluidApiCache(pos);
        if (cache instanceof EmptyFluidLookupCache) {
            return StorageProvider.create(FluidStorage.SIDED, level, pos);
        }
        return StorageProvider.create(cache, level);
    }

    public static StorageProvider<ItemVariant> createForItems(class_1937 level, class_2338 pos) {
        BlockApiCache<Storage<ItemVariant>, class_2350> cache = ((LevelExtensions)level).port_lib$getItemCache(pos);
        if (cache instanceof EmptyItemLookupCache) {
            return StorageProvider.create(ItemStorage.SIDED, level, pos);
        }
        return StorageProvider.create(cache, level);
    }

    public static <T> StorageProvider<T> create(BlockApiCache<Storage<T>, class_2350> cache, class_1937 level) {
        return new CachedStorageProvider<T>(cache, level);
    }

    public static <T> StorageProvider<T> create(BlockApiLookup<Storage<T>, class_2350> lookup, class_1937 level, class_2338 pos) {
        return new StorageProvider<T>(lookup, level, pos);
    }

    protected static class FilteringStorageProvider<T>
    extends StorageProvider<T> {
        private final StorageProvider<T> wrapped;
        private final BiPredicate<StorageProvider<T>, Storage<T>> filter;

        protected FilteringStorageProvider(StorageProvider<T> wrapped, BiPredicate<StorageProvider<T>, Storage<T>> filter) {
            super(wrapped.lookup, wrapped.level, wrapped.pos);
            this.wrapped = wrapped;
            this.filter = filter;
        }

        @Override
        @Nullable
        public Storage<T> get(class_2350 direction) {
            Storage<T> storage = this.wrapped.get(direction);
            if (this.filter.test(this, storage)) {
                return storage;
            }
            return null;
        }

        @Override
        @Nullable
        public class_2586 findBlockEntity() {
            return this.wrapped.findBlockEntity();
        }

        @Override
        public class_2680 findBlockState() {
            return this.wrapped.findBlockState();
        }
    }

    protected static class CachedStorageProvider<T>
    extends StorageProvider<T> {
        private final BlockApiCache<Storage<T>, class_2350> cache;

        public CachedStorageProvider(BlockApiCache<Storage<T>, class_2350> cache, class_1937 level) {
            super(cache.getLookup(), level, cache.getPos());
            this.cache = cache;
        }

        @Override
        public Storage<T> get(class_2350 direction) {
            return (Storage)this.cache.find((Object)direction);
        }

        @Override
        @Nullable
        public class_2586 findBlockEntity() {
            return this.cache.getBlockEntity();
        }

        @Override
        public class_2680 findBlockState() {
            class_2586 be = this.findBlockEntity();
            if (be != null) {
                return be.method_11010();
            }
            return super.findBlockState();
        }
    }
}

