/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import com.google.common.collect.AbstractIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.jetbrains.annotations.Nullable;

public class DualSortedSetIterator<T>
extends AbstractIterator<T> {
    private final Comparator<T> comparator;
    private final Iterator<T> first;
    private final Iterator<T> second;
    private T firstNext;
    private T secondNext;

    public DualSortedSetIterator(SortedSet<T> first, SortedSet<T> second) {
        this.comparator = first.comparator();
        this.first = first.iterator();
        this.second = second.iterator();
    }

    @Nullable
    protected T computeNext() {
        if (this.firstNext == null && this.first.hasNext()) {
            this.firstNext = this.first.next();
        }
        if (this.secondNext == null && this.second.hasNext()) {
            this.secondNext = this.second.next();
        }
        if (this.firstNext == null) {
            if (this.secondNext == null) {
                return (T)this.endOfData();
            }
            return this.consume(this.secondNext);
        }
        if (this.secondNext == null) {
            return this.consume(this.firstNext);
        }
        int compared = this.comparator.compare(this.firstNext, this.secondNext);
        T next = compared <= 0 ? this.firstNext : this.secondNext;
        return this.consume(next);
    }

    private T consume(T element) {
        if (element == this.firstNext) {
            this.firstNext = null;
        }
        if (element == this.secondNext) {
            this.secondNext = null;
        }
        return element;
    }
}

