/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.fluid.item;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class FluidHandlerItemStack
implements Storage<FluidVariant> {
    public static final String FLUID_NBT_KEY = "Fluid";
    @NotNull
    protected ContainerItemContext container;
    protected long capacity;

    public FluidHandlerItemStack(@NotNull ContainerItemContext container, long capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    @NotNull
    public FluidStack getFluid() {
        class_2487 tagCompound = this.container.getItemVariant().getNbt();
        if (tagCompound == null || !tagCompound.method_10545(FLUID_NBT_KEY)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((class_2487)tagCompound.method_10562(FLUID_NBT_KEY));
    }

    protected boolean setFluid(FluidStack fluid, TransactionContext tx) {
        class_1799 newStack = this.container.getItemVariant().toStack();
        if (!newStack.method_7985()) {
            newStack.method_7980(new class_2487());
        }
        class_2487 fluidTag = new class_2487();
        fluid.writeToNBT(fluidTag);
        newStack.method_7969().method_10566(FLUID_NBT_KEY, (class_2520)fluidTag);
        return this.container.exchange(ItemVariant.of((class_1799)newStack), 1L, tx) == 1L;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        long fillAmount;
        if (this.container.getAmount() != 1L || new FluidStack(resource, maxAmount).isEmpty() || !this.canFillFluidType(resource, maxAmount)) {
            return 0L;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            long fillAmount2 = Math.min(this.capacity, maxAmount);
            FluidStack filled = new FluidStack(resource, maxAmount);
            filled.setAmount(fillAmount2);
            if (this.setFluid(filled, transaction)) {
                return fillAmount2;
            }
        } else if (contained.isFluidEqual(resource) && (fillAmount = Math.min(this.capacity - contained.getAmount(), maxAmount)) > 0L) {
            contained.grow(fillAmount);
            if (this.setFluid(contained, transaction)) {
                return fillAmount;
            }
        }
        return 0L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.container.getAmount() != 1L || new FluidStack(resource, maxAmount).isEmpty() || !FluidStack.isFluidEqual((FluidVariant)resource, (FluidVariant)this.getFluid().getType()) || maxAmount <= 0L) {
            return 0L;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty() || !this.canDrainFluidType(contained.getType(), contained.getAmount())) {
            return 0L;
        }
        long drainAmount = Math.min(contained.getAmount(), maxAmount);
        contained.shrink(drainAmount);
        if (contained.isEmpty() ? this.setContainerToEmpty(transaction) : this.setFluid(contained, transaction)) {
            return drainAmount;
        }
        return 0L;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return new Iterator<StorageView<FluidVariant>>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public StorageView<FluidVariant> next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return new FluidHandlerItemStackView();
            }
        };
    }

    public boolean canFillFluidType(FluidVariant variant, long amount) {
        return true;
    }

    public boolean canDrainFluidType(FluidVariant variant, long amount) {
        return true;
    }

    protected boolean setContainerToEmpty(TransactionContext tx) {
        class_1799 newStack = this.container.getItemVariant().toStack();
        newStack.method_7983(FLUID_NBT_KEY);
        return this.container.exchange(ItemVariant.of((class_1799)newStack), 1L, tx) == 1L;
    }

    public static class SwapEmpty
    extends FluidHandlerItemStack {
        protected final class_1799 emptyContainer;

        public SwapEmpty(ContainerItemContext container, class_1799 emptyContainer, int capacity) {
            super(container, capacity);
            this.emptyContainer = emptyContainer;
        }

        @Override
        protected boolean setContainerToEmpty(TransactionContext tx) {
            boolean result = super.setContainerToEmpty(tx);
            try (Transaction nested = tx.openNested();){
                if (this.container.exchange(ItemVariant.of((class_1799)this.emptyContainer), (long)this.emptyContainer.method_7947(), (TransactionContext)nested) == (long)this.emptyContainer.method_7947()) {
                    nested.commit();
                    boolean bl = true;
                    return bl;
                }
            }
            return result;
        }
    }

    public static class Consumable
    extends FluidHandlerItemStack {
        public Consumable(ContainerItemContext container, int capacity) {
            super(container, capacity);
        }

        @Override
        protected boolean setContainerToEmpty(TransactionContext tx) {
            boolean result = super.setContainerToEmpty(tx);
            try (Transaction nested = tx.openNested();){
                if (this.container.extract(this.container.getItemVariant(), 1L, (TransactionContext)nested) == 1L) {
                    nested.commit();
                    boolean bl = true;
                    return bl;
                }
            }
            return result;
        }
    }

    public class FluidHandlerItemStackView
    implements StorageView<FluidVariant> {
        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            return FluidHandlerItemStack.this.extract(resource, maxAmount, transaction);
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public FluidVariant getResource() {
            return FluidHandlerItemStack.this.getFluid().getType();
        }

        public long getAmount() {
            return FluidHandlerItemStack.this.getFluid().getAmount();
        }

        public long getCapacity() {
            return FluidHandlerItemStack.this.capacity;
        }
    }
}

