/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.fluid;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;

public class FluidTank
extends SingleVariantStorage<FluidVariant> {
    protected Predicate<FluidStack> validator;
    protected long capacity;
    protected FluidStack stack = FluidStack.EMPTY;

    public FluidTank(FluidStack fluid, long capacity) {
        this(capacity);
        this.setFluid(fluid);
    }

    public FluidTank(long capacity) {
        this(capacity, fluidStack -> true);
    }

    public FluidTank(long capacity, Predicate<FluidStack> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public FluidTank setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        if (!this.isFluidValid(new FluidStack(insertedVariant, maxAmount))) {
            return 0L;
        }
        long inserted = super.insert((TransferVariant)insertedVariant, maxAmount, transaction);
        this.updateStack();
        return inserted;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
        long extracted = super.extract((TransferVariant)extractedVariant, maxAmount, transaction);
        this.updateStack();
        return extracted;
    }

    private void updateStack() {
        this.stack = new FluidStack((FluidVariant)this.variant, this.amount);
    }

    public FluidTank setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    protected FluidVariant getBlankVariant() {
        return FluidStack.EMPTY.getType();
    }

    protected long getCapacity(FluidVariant variant) {
        return this.getCapacity();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public FluidStack getFluid() {
        return this.stack;
    }

    public void setFluid(FluidStack fluid) {
        this.variant = fluid.getType();
        this.amount = fluid.getAmount();
        this.stack = fluid;
    }

    public class_2487 writeToNBT(class_2487 tag) {
        this.updateStack();
        this.stack.writeToNBT(tag);
        tag.method_10544("Capacity", this.capacity);
        return tag;
    }

    public FluidTank readFromNBT(class_2487 tag) {
        this.setFluid(FluidStack.loadFluidStackFromNBT((class_2487)tag));
        if (tag.method_10545("Capacity")) {
            this.capacity = tag.method_10537("Capacity");
        }
        return this;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().isEmpty();
    }

    public long getFluidAmount() {
        return this.amount;
    }

    public long getSpace() {
        return Math.max(0L, this.capacity - this.getFluid().getAmount());
    }

    protected void onFinalCommit() {
        this.updateStack();
        this.onContentsChanged();
    }

    protected void readSnapshot(ResourceAmount<FluidVariant> snapshot) {
        super.readSnapshot(snapshot);
        this.updateStack();
    }

    protected void onContentsChanged() {
    }
}

