/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.kanos_config.api;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;

public abstract class ConfigHandler<S>
implements Supplier<S> {
    private final String namespace;
    private final ILogger logger;
    private final Path configFile;
    private final Supplier<S> defaultConfig;
    private S cachedConfig = null;
    private Collection<Runnable> invalidationListeners = new ArrayList<Runnable>();

    public ConfigHandler(String namespace, Path path, Supplier<S> defaultConfig) {
        this.namespace = namespace;
        this.logger = MixinService.getService().getLogger(namespace);
        this.configFile = path;
        this.defaultConfig = defaultConfig;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public synchronized void onConfigChanged() {
        if (this.cachedConfig != null) {
            this.save(this.cachedConfig);
            this.invalidate();
        }
    }

    public synchronized void invalidate() {
        this.cachedConfig = null;
        for (Runnable listener : this.invalidationListeners) {
            listener.run();
        }
    }

    public void addInvalidationListener(Runnable listener) {
        this.invalidationListeners.add(listener);
    }

    @Override
    public S get() {
        return this.cachedConfig != null ? this.cachedConfig : (this.cachedConfig = this.load());
    }

    public synchronized S load() {
        S configData;
        block14: {
            configData = null;
            try {
                Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
                if (!Files.exists(this.configFile, new LinkOption[0])) break block14;
                try (Stream<String> lines = Files.lines(this.configFile);){
                    configData = this.readConfig(lines);
                }
                catch (Exception e) {
                    Path configBackup = this.configFile.getParent().resolve(this.configFile.getFileName().toString() + ".bak");
                    this.logger.warn("Failed to read config for {}. A backup is being made at \"{}\". Resetting to default config.", new Object[]{this.namespace, configBackup.toString()});
                    this.logger.catching((Throwable)e);
                    try {
                        Files.copy(this.configFile, configBackup, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e2) {
                        this.logger.warn("Failed to backup old config for {}.", new Object[]{this.namespace});
                        throw e2;
                    }
                }
            }
            catch (IOException e) {
                this.logger.catching((Throwable)e);
            }
        }
        S defaultData = this.defaultConfig.get();
        if (!Objects.equals(configData, defaultData)) {
            S mergedData;
            Object object = mergedData = configData == null ? defaultData : this.mergeConfigs(configData, defaultData);
            if (!Objects.equals(configData, mergedData)) {
                configData = mergedData;
                this.save(configData);
            }
        }
        return configData;
    }

    public void save() {
        this.save(this.get());
    }

    public void save(S configData) {
        try {
            Files.write(this.configFile, this.writeConfig(configData), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.warn("Failed to write config for {}:", new Object[]{this.namespace});
            this.logger.catching((Throwable)e);
        }
    }

    protected abstract S readConfig(Stream<String> var1);

    protected abstract Iterable<? extends CharSequence> writeConfig(S var1) throws IOException;

    protected abstract S mergeConfigs(S var1, S var2);
}

