/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.resources;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PathPackResources
extends class_3255 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path source;

    public PathPackResources(String packId, boolean isBuiltin, Path source) {
        super(packId, isBuiltin);
        this.source = source;
    }

    public Path getSource() {
        return this.source;
    }

    protected Path resolve(String ... paths) {
        Path path = this.getSource();
        for (String name : paths) {
            path = path.resolve(name);
        }
        return path;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... paths) {
        Path path = this.resolve(paths);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        return class_7367.create((Path)path);
    }

    public void method_14408(class_3264 type, String namespace, String path, class_3262.class_7664 resourceOutput) {
        class_4239.method_46346((String)path).get().ifLeft(parts -> class_3259.method_45183((String)namespace, (Path)this.resolve(type.method_14413(), namespace).toAbsolutePath(), (List)parts, (class_3262.class_7664)resourceOutput)).ifRight(dataResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)dataResult.message()));
    }

    public Set<String> method_14406(class_3264 type) {
        return this.getNamespacesFromDisk(type);
    }

    @NotNull
    private Set<String> getNamespacesFromDisk(class_3264 type) {
        Set<String> set;
        block9: {
            Path root = this.resolve(type.method_14413());
            Stream<Path> walker = Files.walk(root, 1, new FileVisitOption[0]);
            try {
                set = walker.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(root::relativize).filter(p -> p.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                if (walker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (type == class_3264.field_14190) {
                        return this.method_14406(class_3264.field_14188);
                    }
                    return Collections.emptySet();
                }
            }
            walker.close();
        }
        return set;
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        return this.method_14410(PathPackResources.getPathFromLocation(location.method_12832().startsWith("lang/") ? class_3264.field_14188 : type, location));
    }

    private static String[] getPathFromLocation(class_3264 type, class_2960 location) {
        String[] parts = location.method_12832().split("/");
        String[] result = new String[parts.length + 2];
        result[0] = type.method_14413();
        result[1] = location.method_12836();
        System.arraycopy(parts, 0, result, 2, parts.length);
        return result;
    }

    public void close() {
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: %s (%s)", ((Object)((Object)this)).getClass().getName(), this.method_14409(), this.getSource());
    }

    @NotNull
    public static PathPackResources createPackForMod(final ModContainer mf) {
        return new PathPackResources(mf.getMetadata().getName(), false, mf.getRootPath()){

            @Override
            @Nonnull
            protected Path resolve(String ... paths) {
                if (paths.length < 1) {
                    throw new IllegalArgumentException("Missing path");
                }
                String path = String.join((CharSequence)"/", paths);
                for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                    if (!modContainer.findPath(path).isPresent()) continue;
                    return (Path)modContainer.findPath(path).get();
                }
                return (Path)mf.findPath(path).orElseThrow();
            }
        };
    }
}

