/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.fabricators_of_create.porting_lib.data.DatapackBuiltinEntriesProvider;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7475;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class PortingLibTagsProvider<T>
extends FabricTagProvider<T> {
    @Nullable
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    private final ExistingFileHelper.IResourceType elementResourceType;

    public PortingLibTagsProvider(FabricDataOutput output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> registriesFuture, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, registryKey, registriesFuture);
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", class_3505.method_40099(registryKey));
        this.elementResourceType = new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", DatapackBuiltinEntriesProvider.prefixNamespace(registryKey.method_29177()));
    }

    @Nullable
    protected Path getPath(class_2960 id) {
        return this.field_39380.method_44107(id);
    }

    public CompletableFuture<?> method_10319(class_7403 pOutput) {
        record CombinedData<T>(class_7225.class_7874 contents, class_2474.class_8211<T> parent) {
        }
        return ((CompletableFuture)((CompletableFuture)this.method_49651().thenApply(p_275895_ -> {
            this.field_43108.complete(null);
            return p_275895_;
        })).thenCombineAsync((CompletionStage)this.field_43093, (x$0, x$1) -> new CombinedData((class_7225.class_7874)x$0, x$1))).thenCompose(combinedData -> {
            class_7225.class_7226 registrylookup = (class_7225.class_7226)combinedData.contents.method_46759(this.field_40957).orElseThrow(() -> new IllegalStateException("Registry " + this.field_40957.method_29177() + " not found"));
            Predicate<class_2960> predicate = p_255496_ -> registrylookup.method_46746(class_5321.method_29179((class_5321)this.field_40957, (class_2960)p_255496_)).isPresent();
            Predicate<class_2960> predicate1 = p_274776_ -> this.field_11481.containsKey(p_274776_) || combinedData.parent.contains(class_6862.method_40092((class_5321)this.field_40957, (class_2960)p_274776_));
            return CompletableFuture.allOf((CompletableFuture[])this.field_11481.entrySet().stream().map(p_255499_ -> {
                class_2960 resourcelocation = (class_2960)p_255499_.getKey();
                class_3495 tagbuilder = (class_3495)p_255499_.getValue();
                List list = tagbuilder.method_26782();
                List<class_3497> list1 = list.stream().filter(tag -> !tag.method_32832(predicate, predicate1)).filter(this::missing).toList();
                if (!list1.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", resourcelocation, list1.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                JsonElement jsonelement = (JsonElement)class_7475.field_39269.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new class_7475(list, false)).getOrThrow(false, arg_0 -> ((Logger)field_11479).error(arg_0));
                Path path = this.getPath(resourcelocation);
                if (path == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return class_2405.method_10320((class_7403)pOutput, (JsonElement)jsonelement, (Path)path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    private boolean missing(class_3497 reference) {
        if (reference.field_39268) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(reference.field_15584, reference.field_39267 ? this.resourceType : this.elementResourceType);
        }
        return false;
    }
}

