/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.impl.client.model.loading.BlockStateResolverHolder;
import net.fabricmc.fabric.impl.client.model.loading.LegacyModelVariantProvider;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModelLoaderPluginContextImpl
implements ModelLoadingPlugin.Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoaderPluginContextImpl.class);
    final Set<class_2960> extraModels = new LinkedHashSet<class_2960>();
    private final Map<BlockKey, BlockStateResolverHolder> blockStateResolvers = new HashMap<BlockKey, BlockStateResolverHolder>();
    private final BlockKey lookupKey = new BlockKey();
    private final Event<ModelResolver> modelResolvers = EventFactory.createArrayBacked(ModelResolver.class, resolvers -> context -> {
        for (ModelResolver resolver : resolvers) {
            try {
                class_1100 model = resolver.resolveModel(context);
                if (model == null) continue;
                return model;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to resolve model", (Throwable)exception);
            }
        }
        return null;
    });
    private static final class_2960[] MODEL_MODIFIER_PHASES = new class_2960[]{ModelModifier.OVERRIDE_PHASE, ModelModifier.DEFAULT_PHASE, ModelModifier.WRAP_PHASE, ModelModifier.WRAP_LAST_PHASE};
    private final Event<ModelModifier.OnLoad> onLoadModifiers = EventFactory.createWithPhases(ModelModifier.OnLoad.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoad modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked model on load", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBake> beforeBakeModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBake modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBake> afterBakeModifiers = EventFactory.createWithPhases(ModelModifier.AfterBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBake modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify baked model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    public final Function<class_2960, class_1100> modelGetter;
    private final Event<LegacyModelVariantProvider> legacyVariantProviders = EventFactory.createArrayBacked(LegacyModelVariantProvider.class, providers -> modelId -> {
        for (LegacyModelVariantProvider provider : providers) {
            try {
                class_1100 model = provider.loadModelVariant(modelId);
                if (model == null) continue;
                return model;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to run legacy model variant provider", (Throwable)exception);
            }
        }
        return null;
    });

    public ModelLoaderPluginContextImpl(Function<class_2960, class_1100> modelGetter) {
        this.modelGetter = modelGetter;
    }

    @Override
    public void addModels(class_2960 ... ids) {
        for (class_2960 id : ids) {
            this.extraModels.add(id);
        }
    }

    @Override
    public void addModels(Collection<? extends class_2960> ids) {
        this.extraModels.addAll(ids);
    }

    @Override
    public void registerBlockStateResolver(class_2248 block, BlockStateResolver resolver) {
        BlockStateResolverHolder holder;
        Objects.requireNonNull(block, "block cannot be null");
        Objects.requireNonNull(resolver, "resolver cannot be null");
        Optional optionalKey = class_7923.field_41175.method_29113((Object)block);
        if (optionalKey.isEmpty()) {
            throw new IllegalArgumentException("Received unregistered block");
        }
        class_2960 blockId = ((class_5321)optionalKey.get()).method_29177();
        BlockKey key = new BlockKey(blockId.method_12836(), blockId.method_12832());
        if (this.blockStateResolvers.put(key, holder = new BlockStateResolverHolder(resolver, block, blockId)) != null) {
            throw new IllegalArgumentException("Duplicate block state resolver for block " + String.valueOf(blockId));
        }
    }

    @Nullable
    BlockStateResolverHolder getBlockStateResolver(class_1091 modelId) {
        BlockKey key = this.lookupKey;
        key.namespace = modelId.method_12836();
        key.path = modelId.method_12832();
        return this.blockStateResolvers.get(key);
    }

    @Override
    public Event<ModelResolver> resolveModel() {
        return this.modelResolvers;
    }

    @Override
    public Event<ModelModifier.OnLoad> modifyModelOnLoad() {
        return this.onLoadModifiers;
    }

    @Override
    public Event<ModelModifier.BeforeBake> modifyModelBeforeBake() {
        return this.beforeBakeModifiers;
    }

    @Override
    public Event<ModelModifier.AfterBake> modifyModelAfterBake() {
        return this.afterBakeModifiers;
    }

    public Event<LegacyModelVariantProvider> legacyVariantProviders() {
        return this.legacyVariantProviders;
    }

    @Environment(value=EnvType.CLIENT)
    private static class BlockKey {
        private String namespace;
        private String path;

        private BlockKey() {
        }

        private BlockKey(String namespace, String path) {
            this.namespace = namespace;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockKey blockKey = (BlockKey)o;
            return this.namespace.equals(blockKey.namespace) && this.path.equals(blockKey.path);
        }

        public int hashCode() {
            return 31 * this.namespace.hashCode() + this.path.hashCode();
        }
    }
}

