/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.fluidcollision;

import be.florens.expandability.EventDispatcher;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_1297.class})
public class EntityMixin {
    @ModifyExpressionValue(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;")})
    private class_243 fluidCollision(class_243 originalDisplacement) {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof class_1309)) {
            return originalDisplacement;
        }
        class_1309 entity = (class_1309)entityMixin;
        if (originalDisplacement.field_1351 <= 0.0 && !EntityMixin.isTouchingFluid(entity, entity.method_5829().method_1011(0.001))) {
            Map<class_243, Double> points = EntityMixin.findFluidDistances(entity, originalDisplacement);
            Double highestDistance = null;
            for (Map.Entry<class_243, Double> point : points.entrySet()) {
                if (highestDistance != null && (point.getValue() == null || !(point.getValue() > highestDistance))) continue;
                highestDistance = point.getValue();
            }
            if (highestDistance != null) {
                class_243 finalDisplacement = new class_243(originalDisplacement.field_1352, highestDistance.doubleValue(), originalDisplacement.field_1350);
                class_238 finalBox = entity.method_5829().method_997(finalDisplacement).method_1011(0.001);
                if (!EntityMixin.isTouchingFluid(entity, finalBox)) {
                    entity.field_6017 = 0.0f;
                    entity.method_24830(true);
                    return finalDisplacement;
                }
            }
        }
        return originalDisplacement;
    }

    @Unique
    private static Map<class_243, Double> findFluidDistances(class_1309 entity, class_243 originalDisplacement) {
        class_238 box = entity.method_5829().method_997(originalDisplacement);
        HashMap<class_243, Double> points = new HashMap<class_243, Double>();
        points.put(new class_243(box.field_1323, box.field_1322, box.field_1321), null);
        points.put(new class_243(box.field_1323, box.field_1322, box.field_1324), null);
        points.put(new class_243(box.field_1320, box.field_1322, box.field_1321), null);
        points.put(new class_243(box.field_1320, box.field_1322, box.field_1324), null);
        double fluidStepHeight = entity.method_24828() ? Math.max(1.0, (double)entity.method_49476()) : 0.0;
        block0: for (Map.Entry entry : points.entrySet()) {
            int i = 0;
            while (true) {
                double limitingVelocity;
                class_2338 landingPos = class_2338.method_49638((class_2374)((class_243)entry.getKey()).method_1031(0.0, (double)i + fluidStepHeight, 0.0));
                class_3610 landingState = entity.method_5770().method_8316(landingPos);
                double distanceToFluidSurface = (double)((float)landingPos.method_10264() + landingState.method_20785()) - entity.method_23318();
                if (distanceToFluidSurface < (limitingVelocity = originalDisplacement.field_1351) || distanceToFluidSurface > fluidStepHeight) continue block0;
                if (!landingState.method_15769() && EventDispatcher.onLivingFluidCollision(entity, landingState)) {
                    entry.setValue(distanceToFluidSurface);
                    continue block0;
                }
                --i;
            }
        }
        return points;
    }

    @Unique
    private static boolean isTouchingFluid(class_1309 entity, class_238 box) {
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15384((double)box.field_1320);
        int minY = class_3532.method_15357((double)box.field_1322);
        int maxY = class_3532.method_15384((double)box.field_1325);
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15384((double)box.field_1324);
        class_1937 world = entity.method_5770();
        if (world.method_22341(minX, minY, minZ, maxX, maxY, maxZ)) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        double surfaceY;
                        mutable.method_10103(x, y, z);
                        class_3610 fluidState = world.method_8316((class_2338)mutable);
                        if (fluidState.method_15769() || !((surfaceY = (double)(fluidState.method_15763((class_1922)world, (class_2338)mutable) + (float)y)) >= box.field_1322)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

