/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import org.apache.commons.lang3.tuple.Pair;

public enum ColoredItem {
    BLACK(class_1802.field_8226, class_1802.field_19059, class_1802.field_8611, class_1802.field_8112, class_1802.field_8410, class_1802.field_8157, class_1802.field_8181, class_1802.field_8096, class_1802.field_8516, class_1802.field_8704, class_1802.field_8268, class_1802.field_8572, class_1802.field_27062),
    BLUE(class_1802.field_8345, class_1802.field_19055, class_1802.field_8115, class_1802.field_8893, class_1802.field_8126, class_1802.field_8747, class_1802.field_8455, class_1802.field_8484, class_1802.field_8164, class_1802.field_8737, class_1802.field_8350, class_1802.field_8128, class_1802.field_27058),
    BROWN(class_1802.field_8099, class_1802.field_19056, class_1802.field_8294, class_1802.field_8464, class_1802.field_8332, class_1802.field_8501, class_1802.field_8467, class_1802.field_8394, class_1802.field_8437, class_1802.field_8762, class_1802.field_8584, class_1802.field_8124, class_1802.field_27059),
    CYAN(class_1802.field_8632, class_1802.field_19053, class_1802.field_8290, class_1802.field_8390, class_1802.field_8685, class_1802.field_8085, class_1802.field_8821, class_1802.field_8257, class_1802.field_8593, class_1802.field_8637, class_1802.field_8213, class_1802.field_8629, class_1802.field_27056),
    GRAY(class_1802.field_8298, class_1802.field_19051, class_1802.field_8875, class_1802.field_8754, class_1802.field_8507, class_1802.field_8871, class_1802.field_8304, class_1802.field_8885, class_1802.field_8818, class_1802.field_8333, class_1802.field_8627, class_1802.field_8617, class_1802.field_27054),
    GREEN(class_1802.field_8408, class_1802.field_19057, class_1802.field_8664, class_1802.field_8368, class_1802.field_8734, class_1802.field_8656, class_1802.field_8798, class_1802.field_8244, class_1802.field_8198, class_1802.field_8120, class_1802.field_8461, class_1802.field_8295, class_1802.field_27060),
    LIGHT_BLUE(class_1802.field_8273, class_1802.field_19047, class_1802.field_8078, class_1802.field_8286, class_1802.field_8869, class_1802.field_8196, class_1802.field_8717, class_1802.field_8640, class_1802.field_8764, class_1802.field_8364, class_1802.field_8829, class_1802.field_8379, class_1802.field_27028),
    LIGHT_GRAY(class_1802.field_8851, class_1802.field_19052, class_1802.field_8654, class_1802.field_8146, class_1802.field_8363, class_1802.field_8240, class_1802.field_8133, class_1802.field_8172, class_1802.field_8558, class_1802.field_8735, class_1802.field_8451, class_1802.field_8855, class_1802.field_27055),
    LIME(class_1802.field_8131, class_1802.field_19049, class_1802.field_8253, class_1802.field_8679, class_1802.field_8340, class_1802.field_8581, class_1802.field_8672, class_1802.field_8649, class_1802.field_8418, class_1802.field_8839, class_1802.field_8548, class_1802.field_8778, class_1802.field_27052),
    MAGENTA(class_1802.field_8669, class_1802.field_19046, class_1802.field_8384, class_1802.field_8349, class_1802.field_8243, class_1802.field_8119, class_1802.field_8783, class_1802.field_8318, class_1802.field_8336, class_1802.field_8508, class_1802.field_8050, class_1802.field_8671, class_1802.field_27027),
    NEUTRAL(null, null, null, null, class_1802.field_8280, class_1802.field_8141, class_1802.field_8260, null, null, null, class_1802.field_8545, null, class_1802.field_27024),
    ORANGE(class_1802.field_8492, class_1802.field_19045, class_1802.field_8683, class_1802.field_8059, class_1802.field_8393, class_1802.field_8761, class_1802.field_8043, class_1802.field_8139, class_1802.field_8487, class_1802.field_8771, class_1802.field_8380, class_1802.field_8824, class_1802.field_27026),
    PINK(class_1802.field_8330, class_1802.field_19050, class_1802.field_8580, class_1802.field_8417, class_1802.field_8770, class_1802.field_8500, class_1802.field_8853, class_1802.field_8277, class_1802.field_8222, class_1802.field_8127, class_1802.field_8520, class_1802.field_8329, class_1802.field_27053),
    PURPLE(class_1802.field_8296, class_1802.field_19054, class_1802.field_8098, class_1802.field_8262, class_1802.field_8838, class_1802.field_8739, class_1802.field_8715, class_1802.field_8562, class_1802.field_8690, class_1802.field_8411, class_1802.field_8816, class_1802.field_8405, class_1802.field_27057),
    RED(class_1802.field_8264, class_1802.field_19058, class_1802.field_8482, class_1802.field_8789, class_1802.field_8636, class_1802.field_8879, class_1802.field_8353, class_1802.field_8870, class_1802.field_8757, class_1802.field_8197, class_1802.field_8676, class_1802.field_8586, class_1802.field_27061),
    WHITE(class_1802.field_8446, class_1802.field_19044, class_1802.field_8850, class_1802.field_8258, class_1802.field_8483, class_1802.field_8736, class_1802.field_8156, class_1802.field_8177, class_1802.field_8582, class_1802.field_8341, class_1802.field_8722, class_1802.field_8539, class_1802.field_27025),
    YELLOW(class_1802.field_8192, class_1802.field_19048, class_1802.field_8142, class_1802.field_8863, class_1802.field_8095, class_1802.field_8703, class_1802.field_8385, class_1802.field_8889, class_1802.field_8205, class_1802.field_8686, class_1802.field_8271, class_1802.field_8049, class_1802.field_27029);

    private class_1792 dye;
    private class_1792 wool;
    private class_1792 carpet;
    private class_1792 bed;
    private class_1792 glass;
    private class_1792 glassPane;
    private class_1792 terracotta;
    private class_1792 glazedTerracotta;
    private class_1792 concretePowder;
    private class_1792 concrete;
    private class_1792 shulkerBox;
    private class_1792 banner;
    private class_1792 candle;
    private static Map<Pair<ColoredItem, ColoredItem>, ColoredItem> vanillaMixingMap;
    private static Map<Pair<ColoredItem, ColoredItem>, ColoredItem> extendedMixingMap;
    private static Map<Pair<ColoredItem, ColoredItem>, ColoredItem> extendedMixingMapNoNeutral;

    private ColoredItem(class_1792 dye, class_1792 wool, class_1792 carpet, class_1792 bed, class_1792 glass, class_1792 glassPane, class_1792 terracotta, class_1792 glazedTerracotta, class_1792 concretePowder, class_1792 concrete, class_1792 shulkerBox, class_1792 banner, class_1792 candle) {
        this.dye = dye;
        this.wool = wool;
        this.carpet = carpet;
        this.bed = bed;
        this.glass = glass;
        this.glassPane = glassPane;
        this.terracotta = terracotta;
        this.glazedTerracotta = glazedTerracotta;
        this.concretePowder = concretePowder;
        this.concrete = concrete;
        this.shulkerBox = shulkerBox;
        this.banner = banner;
        this.candle = candle;
    }

    private static void putSym(ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem> builder, ColoredItem item1, ColoredItem item2, ColoredItem result) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(item1);
        Objects.requireNonNull(item2);
        Objects.requireNonNull(result);
        builder.put((Object)Pair.of((Object)((Object)item1), (Object)((Object)item2)), (Object)result);
        builder.put((Object)Pair.of((Object)((Object)item2), (Object)((Object)item1)), (Object)result);
    }

    public static Map<Pair<ColoredItem, ColoredItem>, ColoredItem> getVanillaMixingMap() {
        if (vanillaMixingMap != null) {
            return vanillaMixingMap;
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ColoredItem item : ColoredItem.values()) {
            if (item == NEUTRAL) continue;
            ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, NEUTRAL, item, item);
        }
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLUE, GREEN, CYAN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLACK, WHITE, GRAY);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, PURPLE, PINK, MAGENTA);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLUE, WHITE, LIGHT_BLUE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, GRAY, WHITE, LIGHT_GRAY);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, GREEN, WHITE, LIME);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, RED, WHITE, PINK);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, RED, BLUE, PURPLE);
        vanillaMixingMap = builder.build();
        return vanillaMixingMap;
    }

    public static Stream<Pair<ColoredItem, ColoredItem>> createVanillaMixingColorStream(ColoredItem color) {
        Objects.requireNonNull(color);
        return ColoredItem.getVanillaMixingMap().entrySet().stream().filter(entry -> ((Pair)entry.getKey()).getLeft() == color).map(entry -> Pair.of((Object)((Object)((ColoredItem)((Object)((Object)((Pair)entry.getKey()).getRight())))), (Object)((Object)((ColoredItem)((Object)((Object)entry.getValue()))))));
    }

    public static Map<ColoredItem, ColoredItem> createVanillaMixingColorMap(ColoredItem color) {
        Objects.requireNonNull(color);
        return ColoredItem.createVanillaMixingColorStream(color).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public static Map<Pair<ColoredItem, ColoredItem>, ColoredItem> getExtendedMixingMap(boolean withNeutral) {
        if (withNeutral && extendedMixingMap != null) {
            return extendedMixingMap;
        }
        if (!withNeutral && extendedMixingMapNoNeutral != null) {
            return extendedMixingMapNoNeutral;
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.putAll(ColoredItem.getVanillaMixingMap());
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLACK, GRAY, BLACK);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLUE, LIGHT_BLUE, BLUE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLUE, CYAN, BLUE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, GRAY, CYAN, BLUE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLACK, ORANGE, BROWN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BROWN, ORANGE, BROWN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, GREEN, RED, BROWN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, LIGHT_BLUE, CYAN, CYAN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, GRAY, LIGHT_GRAY, GRAY);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLACK, LIGHT_GRAY, GRAY);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLUE, YELLOW, GREEN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, LIME, GRAY, GREEN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, LIME, GREEN, GREEN);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, PINK, GRAY, MAGENTA);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, BLUE, LIGHT_GRAY, LIGHT_BLUE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, CYAN, LIGHT_GRAY, LIGHT_BLUE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, LIGHT_GRAY, LIGHT_BLUE, LIGHT_BLUE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, WHITE, LIGHT_GRAY, LIGHT_GRAY);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, YELLOW, LIGHT_BLUE, LIME);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, YELLOW, CYAN, LIME);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, YELLOW, ORANGE, ORANGE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, PINK, ORANGE, ORANGE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, MAGENTA, LIGHT_GRAY, PINK);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, MAGENTA, WHITE, PINK);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, MAGENTA, BLUE, PURPLE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, MAGENTA, PURPLE, PURPLE);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, MAGENTA, RED, RED);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, ORANGE, RED, RED);
        ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, PINK, RED, RED);
        extendedMixingMap = builder.build();
        builder = new ImmutableMap.Builder();
        for (Map.Entry<Pair<ColoredItem, ColoredItem>, ColoredItem> entry : extendedMixingMap.entrySet()) {
            if (entry.getKey().getLeft() == NEUTRAL || entry.getKey().getRight() == NEUTRAL || entry.getKey().getLeft() == WHITE || entry.getKey().getRight() == WHITE) continue;
            builder.put(entry);
        }
        for (ColoredItem item : ColoredItem.values()) {
            if (item == WHITE || item == NEUTRAL) continue;
            ColoredItem.putSym((ImmutableMap.Builder<Pair<ColoredItem, ColoredItem>, ColoredItem>)builder, WHITE, item, item);
        }
        extendedMixingMapNoNeutral = builder.build();
        if (withNeutral) {
            return extendedMixingMap;
        }
        return extendedMixingMapNoNeutral;
    }

    public static Stream<Pair<ColoredItem, ColoredItem>> createExtendedMixingColorStream(ColoredItem color, boolean withNeutral, boolean differentResults) {
        Objects.requireNonNull(color);
        return ColoredItem.getExtendedMixingMap(withNeutral).entrySet().stream().filter(entry -> ((Pair)entry.getKey()).getLeft() == color && (!differentResults || ((Pair)entry.getKey()).getRight() != entry.getValue())).map(entry -> Pair.of((Object)((Object)((ColoredItem)((Object)((Object)((Pair)entry.getKey()).getRight())))), (Object)((Object)((ColoredItem)((Object)((Object)entry.getValue()))))));
    }

    public static Map<ColoredItem, ColoredItem> createExtendedMixingColorMap(ColoredItem color, boolean withNeutral, boolean differentResults) {
        Objects.requireNonNull(color);
        return ColoredItem.createExtendedMixingColorStream(color, withNeutral, differentResults).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public class_1792 getDye() {
        return this.dye;
    }

    public class_1792 getWool() {
        return this.wool;
    }

    public class_1792 getCarpet() {
        return this.carpet;
    }

    public class_1792 getBed() {
        return this.bed;
    }

    public class_1792 getGlass() {
        return this.glass;
    }

    public class_1792 getGlassPane() {
        return this.glassPane;
    }

    public class_1792 getTerracotta() {
        return this.terracotta;
    }

    public class_1792 getGlazedTerracotta() {
        return this.glazedTerracotta;
    }

    public class_1792 getConcretePowder() {
        return this.concretePowder;
    }

    public class_1792 getConcrete() {
        return this.concrete;
    }

    public class_1792 getShulkerBox() {
        return this.shulkerBox;
    }

    public class_1792 getBanner() {
        return this.banner;
    }

    public class_1792 getCandle() {
        return this.candle;
    }

    static {
        vanillaMixingMap = null;
        extendedMixingMap = null;
        extendedMixingMapNoNeutral = null;
    }
}

