/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import java.util.function.BiPredicate;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public interface MultiblockWriter {
    public MultiblockWriter add(int var1, int var2, int var3, BiPredicate<class_1922, class_2338> var4, class_2680 var5);

    default public MultiblockWriter fill(int ax, int ay, int az, int bx, int by, int bz, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
        for (int x = ax; x < bx; ++x) {
            for (int y = ay; y < by; ++y) {
                for (int z = az; z < bz; ++z) {
                    this.add(x, y, z, predicate, state);
                }
            }
        }
        return this;
    }

    default public MultiblockWriter ring(class_2350.class_2351 through, int pX, int pY, int pZ, BiPredicate<class_1922, class_2338> predicate, class_2680 state, BiPredicate<class_1922, class_2338> holePredicate, class_2680 holeHologramState) {
        block12: {
            block13: {
                block11: {
                    if (holePredicate == null) {
                        holePredicate = predicate.negate();
                    }
                    if (holeHologramState == null) {
                        holeHologramState = class_2246.field_10124.method_9564();
                    }
                    if (through != class_2350.class_2351.field_11048) break block11;
                    for (int y = 0; y < pY; ++y) {
                        for (int z = 0; z < pZ; ++z) {
                            if (y == 0 || y == pY - 1 || z == 0 || z == pZ - 1) {
                                this.add(pX, y, z, predicate, state);
                                continue;
                            }
                            this.add(pX, y, z, holePredicate, holeHologramState);
                        }
                    }
                    break block12;
                }
                if (through != class_2350.class_2351.field_11052) break block13;
                for (int x = 0; x < pX; ++x) {
                    for (int z = 0; z < pZ; ++z) {
                        if (x == 0 || x == pX - 1 || z == 0 || z == pZ - 1) {
                            this.add(x, pY, z, predicate, state);
                            continue;
                        }
                        this.add(x, pY, z, holePredicate, holeHologramState);
                    }
                }
                break block12;
            }
            if (through != class_2350.class_2351.field_11051) break block12;
            for (int x = 0; x < pX; ++x) {
                for (int y = 0; y < pY; ++y) {
                    if (x == 0 || x == pX - 1 || y == 0 || y == pY - 1) {
                        this.add(x, y, pZ, predicate, state);
                        continue;
                    }
                    this.add(x, y, pZ, holePredicate, holeHologramState);
                }
            }
        }
        return this;
    }

    default public MultiblockWriter ringWithAir(class_2350.class_2351 through, int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
        return this.ring(through, x, y, z, predicate, state, (view, pos) -> view.method_8320(pos).method_26204() == class_2246.field_10124, class_2246.field_10124.method_9564());
    }

    default public MultiblockWriter add(int x, int y, int z, class_2680 state) {
        return this.add(x, y, z, (view, pos) -> view.method_8320(pos) == state, state);
    }

    default public MultiblockWriter fill(int ax, int ay, int az, int bx, int by, int bz, class_2680 state) {
        return this.fill(ax, ay, az, bx, by, bz, (view, pos) -> view.method_8320(pos) == state, state);
    }

    default public MultiblockWriter ring(class_2350.class_2351 through, int x, int y, int z, class_2680 state, class_2680 holeState) {
        return this.ring(through, x, y, z, (view, pos) -> view.method_8320(pos) == state, state, (view, pos) -> view.method_8320(pos) == holeState, holeState);
    }

    default public MultiblockWriter ringWithAir(class_2350.class_2351 through, int x, int y, int z, class_2680 state) {
        return this.ringWithAir(through, x, y, z, (view, pos) -> view.method_8320(pos) == state, state);
    }

    default public MultiblockWriter translate(int offsetX, int offsetY, int offsetZ) {
        return (x, y, z, predicate, state) -> this.add(offsetX + x, offsetY + y, offsetZ + z, predicate, state);
    }

    default public MultiblockWriter rotate() {
        return (x, y, z, predicate, state) -> this.add(-z, y, x, predicate, state);
    }

    default public MultiblockWriter rotate(class_2350 direction) {
        MultiblockWriter w = this;
        switch (direction) {
            case field_11043: {
                w = w.rotate();
            }
            case field_11039: {
                w = w.rotate();
            }
            case field_11035: {
                w = w.rotate();
            }
        }
        return w;
    }

    public static class MultiblockVerifier
    implements MultiblockWriter {
        private final class_2338 relative;
        private final class_1922 view;
        private boolean valid = true;

        public MultiblockVerifier(class_2338 relative, class_1922 view) {
            this.relative = relative;
            this.view = view;
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public MultiblockWriter add(int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
            if (this.valid) {
                this.valid = predicate.test(this.view, this.relative.method_10069(x, y, z));
            }
            return this;
        }
    }

    public record DebugWriter(MultiblockWriter writer) implements MultiblockWriter
    {
        @Override
        public MultiblockWriter add(int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
            System.out.printf("\t%d\t%d\t%d\t%s\n", x, y, z, state.method_26204());
            if (this.writer != null) {
                this.writer.add(x, y, z, predicate, state);
            }
            return this;
        }
    }
}

