/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_332;
import reborncore.RebornCore;
import reborncore.client.ClientNetworkManager;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.config.elements.AbstractConfigPopupElement;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.network.ServerBoundPackets;
import reborncore.common.util.Color;

@Environment(value=EnvType.CLIENT)
public class SlotConfigPopupElement
extends AbstractConfigPopupElement {
    private final int id;
    private final boolean allowInput;

    public SlotConfigPopupElement(int slotId, int x, int y, boolean allowInput) {
        super(x, y, GuiSprites.SLOT_CONFIG_POPUP);
        this.id = slotId;
        this.allowInput = allowInput;
    }

    @Override
    public void cycleConfig(class_2350 side, GuiBase<?> guiBase) {
        SlotConfiguration.SlotConfig currentSlot = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id).getSideDetail(side);
        SlotConfiguration.ExtractConfig nextConfig = currentSlot.getSlotIO().getIoConfig().getNext();
        if (!this.allowInput && nextConfig == SlotConfiguration.ExtractConfig.INPUT) {
            nextConfig = SlotConfiguration.ExtractConfig.OUTPUT;
        }
        SlotConfiguration.SlotIO slotIO = new SlotConfiguration.SlotIO(nextConfig);
        SlotConfiguration.SlotConfig newConfig = new SlotConfiguration.SlotConfig(side, slotIO, this.id);
        IdentifiedPacket packetSlotSave = ServerBoundPackets.createPacketSlotSave(guiBase.be.method_11016(), newConfig);
        ClientNetworkManager.sendToServer(packetSlotSave);
    }

    public void updateCheckBox(String type, GuiBase<?> guiBase) {
        SlotConfiguration.SlotConfigHolder configHolder = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id);
        boolean input = configHolder.autoInput();
        boolean output = configHolder.autoOutput();
        boolean filter = configHolder.filter();
        if (type.equalsIgnoreCase("input")) {
            boolean bl = input = !configHolder.autoInput();
        }
        if (type.equalsIgnoreCase("output")) {
            boolean bl = output = !configHolder.autoOutput();
        }
        if (type.equalsIgnoreCase("filter")) {
            filter = !configHolder.filter();
        }
        IdentifiedPacket packetSlotSave = ServerBoundPackets.createPacketIOSave(guiBase.be.method_11016(), this.id, input, output, filter);
        ClientNetworkManager.sendToServer(packetSlotSave);
    }

    @Override
    protected void drawSateColor(class_332 drawContext, GuiBase<?> gui, class_2350 side, int inx, int iny) {
        int sx = inx + this.getX() + gui.getGuiLeft();
        int sy = (iny += 4) + this.getY() + gui.getGuiTop();
        SlotConfiguration.SlotConfigHolder slotConfigHolder = gui.getMachine().getSlotConfiguration().getSlotDetails(this.id);
        if (slotConfigHolder == null) {
            RebornCore.LOGGER.debug("Hmm, this isn't supposed to happen");
            return;
        }
        SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(side);
        Color color = switch (slotConfig.getSlotIO().getIoConfig()) {
            case SlotConfiguration.ExtractConfig.INPUT -> new Color(0, 0, 255, 128);
            case SlotConfiguration.ExtractConfig.OUTPUT -> new Color(255, 69, 0, 128);
            default -> new Color(0, 0, 0, 0);
        };
        drawContext.method_25294(sx, sy, sx + 18, sy + 18, color.getColor());
    }
}

