/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import reborncore.client.ClientChatUtils;
import reborncore.client.ClientNetworkManager;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.config.GuiTab;
import reborncore.client.gui.config.elements.ConfigSlotElement;
import reborncore.client.gui.config.elements.SlotType;
import reborncore.common.network.ServerBoundPackets;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.util.Color;

@Environment(value=EnvType.CLIENT)
public class SlotConfigGui
extends GuiTab {
    private Int2ObjectMap<ConfigSlotElement> slotElementMap = new Int2ObjectOpenHashMap();
    @Nullable
    private ConfigSlotElement selectedSlot;

    public SlotConfigGui(GuiBase<?> guiBase) {
        super(guiBase);
    }

    @Override
    public String name() {
        return "reborncore.gui.tooltip.config_slots";
    }

    @Override
    public boolean enabled() {
        return this.machine.hasSlotConfig();
    }

    @Override
    public class_1799 stack() {
        return GuiBase.wrenchStack;
    }

    @Override
    public void open() {
        this.selectedSlot = null;
        this.slotElementMap.clear();
        BuiltScreenHandler container = this.guiBase.builtScreenHandler;
        for (class_1735 slot : container.field_7761) {
            if (this.guiBase.be != slot.field_7871) continue;
            ConfigSlotElement slotElement = new ConfigSlotElement(this.guiBase.getMachine().getOptionalInventory().get(), slot.method_34266(), SlotType.NORMAL, slot.field_7873 - this.guiBase.getGuiLeft() + 50, slot.field_7872 - this.guiBase.getGuiTop() - 25, this.guiBase, this::close);
            this.slotElementMap.put(slot.method_34266(), (Object)slotElement);
        }
    }

    @Override
    public void close() {
        this.selectedSlot = null;
    }

    @Override
    public void draw(class_332 drawContext, int x, int y) {
        BuiltScreenHandler container = this.guiBase.builtScreenHandler;
        for (class_1735 slot : container.field_7761) {
            if (this.guiBase.be != slot.field_7871) continue;
            Color color = new Color(255, 0, 0, 128);
            drawContext.method_25294(slot.field_7873 - 1, slot.field_7872 - 1, slot.field_7873 + 17, slot.field_7872 + 17, color.getColor());
        }
        if (this.selectedSlot != null) {
            this.selectedSlot.draw(drawContext, this.guiBase, x, y);
        }
    }

    @Override
    public boolean click(double mouseX, double mouseY, int mouseButton) {
        BuiltScreenHandler screenHandler = Objects.requireNonNull(this.guiBase.builtScreenHandler);
        if (this.selectedSlot != null) {
            return this.selectedSlot.onClick(this.guiBase, mouseX, mouseY);
        }
        for (class_1735 slot : screenHandler.field_7761) {
            if (this.guiBase.be != slot.field_7871 || !this.guiBase.isPointInRect(slot.field_7873, slot.field_7872, 18, 18, mouseX, mouseY)) continue;
            this.selectedSlot = (ConfigSlotElement)this.slotElementMap.get(slot.method_34266());
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPress(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25441() && keyCode == 67) {
            this.copyToClipboard();
            return true;
        }
        if (class_437.method_25441() && keyCode == 86) {
            this.pasteFromClipboard();
            return true;
        }
        if (keyCode == 256 && this.selectedSlot != null) {
            this.selectedSlot = null;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getTips() {
        return List.of("reborncore.gui.slotconfigtip.slot", "reborncore.gui.slotconfigtip.side1", "reborncore.gui.slotconfigtip.side2", "reborncore.gui.slotconfigtip.side3", "reborncore.gui.slotconfigtip.copy1", "reborncore.gui.slotconfigtip.copy2");
    }

    private void copyToClipboard() {
        this.machine.getSlotConfiguration();
        String json = this.machine.getSlotConfiguration().toJson(this.machine.getClass().getCanonicalName());
        class_310.method_1551().field_1774.method_1455(json);
        ClientChatUtils.addHudMessage((class_2561)class_2561.method_43470((String)"Slot configuration copied to clipboard"));
    }

    private void pasteFromClipboard() {
        this.machine.getSlotConfiguration();
        String json = class_310.method_1551().field_1774.method_1460();
        try {
            this.machine.getSlotConfiguration().readJson(json, this.machine.getClass().getCanonicalName());
            ClientNetworkManager.sendToServer(ServerBoundPackets.createPacketConfigSave(this.machine.method_11016(), this.machine.getSlotConfiguration()));
            ClientChatUtils.addHudMessage((class_2561)class_2561.method_43470((String)"Slot configuration loaded from clipboard"));
        }
        catch (UnsupportedOperationException e) {
            ClientChatUtils.addHudMessage((class_2561)class_2561.method_43470((String)e.getMessage()));
        }
    }

    public ConfigSlotElement getSelectedSlot() {
        return this.selectedSlot;
    }
}

