/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.server;

import java.io.InputStream;
import java.io.Reader;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.server.Launcher;

public class DefaultLauncher
implements Launcher {
    protected Globals g = JsePlatform.standardGlobals();

    @Override
    public Object[] launch(String script, Object[] arg) {
        return this.launchChunk(this.g.load(script, "main"), arg);
    }

    @Override
    public Object[] launch(InputStream script, Object[] arg) {
        return this.launchChunk(this.g.load(script, "main", "bt", (LuaValue)this.g), arg);
    }

    @Override
    public Object[] launch(Reader script, Object[] arg) {
        return this.launchChunk(this.g.load(script, "main"), arg);
    }

    private Object[] launchChunk(LuaValue chunk, Object[] arg) {
        LuaValue[] args = new LuaValue[arg.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = CoerceJavaToLua.coerce(arg[i]);
        }
        Varargs results = chunk.invoke(LuaValue.varargsOf((LuaValue[])args));
        int n = results.narg();
        Object[] return_values = new Object[n];
        block9: for (int i = 0; i < n; ++i) {
            LuaValue r = results.arg(i + 1);
            switch (r.type()) {
                case 1: {
                    return_values[i] = r.toboolean();
                    continue block9;
                }
                case 3: {
                    return_values[i] = r.todouble();
                    continue block9;
                }
                case -2: {
                    return_values[i] = r.toint();
                    continue block9;
                }
                case 0: {
                    return_values[i] = null;
                    continue block9;
                }
                case 4: {
                    return_values[i] = r.tojstring();
                    continue block9;
                }
                case 7: {
                    return_values[i] = r.touserdata();
                    continue block9;
                }
                default: {
                    return_values[i] = r;
                }
            }
        }
        return return_values;
    }
}

