/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.UpvalInfo;
import org.luaj.vm2.luajc.VarInfo;

public class ProtoInfo {
    public final String name;
    public final Prototype prototype;
    public final ProtoInfo[] subprotos;
    public final BasicBlock[] blocks;
    public final BasicBlock[] blocklist;
    public final VarInfo[] params;
    public final VarInfo[][] vars;
    public final UpvalInfo[] upvals;
    public final UpvalInfo[][] openups;

    public ProtoInfo(Prototype p, String name) {
        this(p, name, null);
    }

    private ProtoInfo(Prototype p, String name, UpvalInfo[] u) {
        UpvalInfo[] upvalInfoArray;
        this.name = name;
        this.prototype = p;
        if (u != null) {
            upvalInfoArray = u;
        } else {
            UpvalInfo[] upvalInfoArray2 = new UpvalInfo[1];
            upvalInfoArray = upvalInfoArray2;
            upvalInfoArray2[0] = new UpvalInfo(this);
        }
        this.upvals = upvalInfoArray;
        this.subprotos = p.p != null && p.p.length > 0 ? new ProtoInfo[p.p.length] : null;
        this.blocks = BasicBlock.findBasicBlocks(p);
        this.blocklist = BasicBlock.findLiveBlocks(this.blocks);
        this.params = new VarInfo[p.maxstacksize];
        for (int slot = 0; slot < p.maxstacksize; ++slot) {
            VarInfo v;
            this.params[slot] = v = VarInfo.PARAM(slot);
        }
        this.vars = this.findVariables();
        this.replaceTrivialPhiVariables();
        this.openups = new UpvalInfo[p.maxstacksize][];
        this.findUpvalues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        StringBuffer sb = new StringBuffer();
        sb.append("proto '" + this.name + "'\n");
        int n2 = n = this.upvals != null ? this.upvals.length : 0;
        for (int i = 0; i < n; ++i) {
            sb.append(" up[" + i + "]: " + this.upvals[i] + "\n");
        }
        BasicBlock[] i = this.blocklist;
        n = i.length;
        for (int j = 0; j < n; ++j) {
            BasicBlock b = i[j];
            int pc0 = b.pc0;
            sb.append("  block " + b.toString());
            this.appendOpenUps(sb, -1);
            for (int pc = pc0; pc <= b.pc1; ++pc) {
                this.appendOpenUps(sb, pc);
                sb.append("     ");
                for (int j2 = 0; j2 < this.prototype.maxstacksize; ++j2) {
                    VarInfo v = this.vars[j2][pc];
                    String u = v == null ? "" : (v.upvalue != null ? (!v.upvalue.rw ? "[C] " : (v.allocupvalue && v.pc == pc ? "[*] " : "[]  ")) : "    ");
                    String s = v == null ? "null   " : String.valueOf(v);
                    sb.append(s + u);
                }
                sb.append("  ");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ops = Print.ps;
                Print.ps = new PrintStream(baos);
                try {
                    Print.printOpCode((Prototype)this.prototype, (int)pc);
                }
                finally {
                    Print.ps.close();
                    Print.ps = ops;
                }
                sb.append(baos.toString());
                sb.append("\n");
            }
        }
        int n3 = n = this.subprotos != null ? this.subprotos.length : 0;
        for (int i2 = 0; i2 < n; ++i2) {
            sb.append(this.subprotos[i2].toString());
        }
        return sb.toString();
    }

    private void appendOpenUps(StringBuffer sb, int pc) {
        for (int j = 0; j < this.prototype.maxstacksize; ++j) {
            VarInfo v;
            VarInfo varInfo = v = pc < 0 ? this.params[j] : this.vars[j][pc];
            if (v == null || v.pc != pc || !v.allocupvalue) continue;
            sb.append("    open: " + v.upvalue + "\n");
        }
    }

    private VarInfo[][] findVariables() {
        int n = this.prototype.code.length;
        int m = this.prototype.maxstacksize;
        VarInfo[][] v = new VarInfo[m][];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new VarInfo[n];
        }
        BasicBlock[] basicBlockArray = this.blocklist;
        int n2 = basicBlockArray.length;
        for (int i = 0; i < n2; ++i) {
            BasicBlock element;
            BasicBlock b0 = element = basicBlockArray[i];
            int nprev = b0.prev != null ? b0.prev.length : 0;
            for (int slot = 0; slot < m; ++slot) {
                VarInfo var = null;
                if (nprev == 0) {
                    var = this.params[slot];
                } else if (nprev == 1) {
                    var = v[slot][b0.prev[0].pc1];
                } else {
                    for (int i2 = 0; i2 < nprev; ++i2) {
                        BasicBlock bp = b0.prev[i2];
                        if (v[slot][bp.pc1] != VarInfo.INVALID) continue;
                        var = VarInfo.INVALID;
                    }
                }
                if (var == null) {
                    var = VarInfo.PHI(this, slot, b0.pc0);
                }
                v[slot][b0.pc0] = var;
            }
            block29: for (int pc = b0.pc0; pc <= b0.pc1; ++pc) {
                if (pc > b0.pc0) {
                    ProtoInfo.propogateVars(v, pc - 1, pc);
                }
                int ins = this.prototype.code[pc];
                int op = Lua.GET_OPCODE((int)ins);
                switch (op) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 11: {
                        int a = Lua.GETARG_A((int)ins);
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 0: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 28: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        v[b][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        if (!Lua.ISK((int)b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (!Lua.ISK((int)c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 10: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        v[a][pc].isreferenced = true;
                        if (!Lua.ISK((int)b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (Lua.ISK((int)c)) continue block29;
                        v[c][pc].isreferenced = true;
                        continue block29;
                    }
                    case 8: {
                        int b = Lua.GETARG_B((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        if (!Lua.ISK((int)b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (Lua.ISK((int)c)) continue block29;
                        v[c][pc].isreferenced = true;
                        continue block29;
                    }
                    case 22: {
                        int b;
                        int a = Lua.GETARG_A((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        for (b = Lua.GETARG_B((int)ins); b <= c; ++b) {
                            v[b][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 33: {
                        int a = Lua.GETARG_A((int)ins);
                        v[a + 2][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 7: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        v[b][pc].isreferenced = true;
                        if (!Lua.ISK((int)c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 6: {
                        int a = Lua.GETARG_A((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        if (!Lua.ISK((int)c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 12: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        v[b][pc].isreferenced = true;
                        if (!Lua.ISK((int)c)) {
                            v[c][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        v[a + 1][pc] = new VarInfo(a + 1, pc);
                        continue block29;
                    }
                    case 32: {
                        int a = Lua.GETARG_A((int)ins);
                        v[a][pc].isreferenced = true;
                        v[a + 2][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        v[a][pc].isreferenced = true;
                        v[a + 1][pc].isreferenced = true;
                        v[a + 3][pc] = new VarInfo(a + 3, pc);
                        continue block29;
                    }
                    case 4: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        while (b-- >= 0) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++a;
                        }
                        continue block29;
                    }
                    case 38: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        int j = 1;
                        while (j < b) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++j;
                            ++a;
                        }
                        if (b != 0) continue block29;
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    case 29: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        v[a][pc].isreferenced = true;
                        v[a][pc].isreferenced = true;
                        for (int i3 = 1; i3 <= b - 1; ++i3) {
                            v[a + i3][pc].isreferenced = true;
                        }
                        int j = 0;
                        while (j <= c - 2) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++j;
                            ++a;
                        }
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    case 34: {
                        int a = Lua.GETARG_A((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        v[a++][pc].isreferenced = true;
                        v[a++][pc].isreferenced = true;
                        v[a++][pc].isreferenced = true;
                        int j = 0;
                        while (j < c) {
                            v[a][pc] = new VarInfo(a, pc);
                            ++j;
                            ++a;
                        }
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    case 35: {
                        int a = Lua.GETARG_A((int)ins);
                        v[a + 1][pc].isreferenced = true;
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 30: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        v[a][pc].isreferenced = true;
                        for (int i4 = 1; i4 <= b - 1; ++i4) {
                            v[a + i4][pc].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 31: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        for (int i5 = 0; i5 <= b - 2; ++i5) {
                            v[a + i5][pc].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 37: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_Bx((int)ins);
                        Upvaldesc[] upvalues = this.prototype.p[b].upvalues;
                        int nups = upvalues.length;
                        for (int k = 0; k < nups; ++k) {
                            if (!upvalues[k].instack) continue;
                            v[upvalues[k].idx][pc].isreferenced = true;
                        }
                        v[a][pc] = new VarInfo(a, pc);
                        continue block29;
                    }
                    case 36: {
                        int a = Lua.GETARG_A((int)ins);
                        int b = Lua.GETARG_B((int)ins);
                        v[a][pc].isreferenced = true;
                        for (int i6 = 1; i6 <= b; ++i6) {
                            v[a + i6][pc].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 9: 
                    case 27: {
                        int a = Lua.GETARG_A((int)ins);
                        v[a][pc].isreferenced = true;
                        continue block29;
                    }
                    case 24: 
                    case 25: 
                    case 26: {
                        int b = Lua.GETARG_B((int)ins);
                        int c = Lua.GETARG_C((int)ins);
                        if (!Lua.ISK((int)b)) {
                            v[b][pc].isreferenced = true;
                        }
                        if (Lua.ISK((int)c)) continue block29;
                        v[c][pc].isreferenced = true;
                        continue block29;
                    }
                    case 23: {
                        int a = Lua.GETARG_A((int)ins);
                        if (a <= 0) continue block29;
                        --a;
                        while (a < m) {
                            v[a][pc] = VarInfo.INVALID;
                            ++a;
                        }
                        continue block29;
                    }
                    default: {
                        throw new IllegalStateException("unhandled opcode: " + ins);
                    }
                }
            }
        }
        return v;
    }

    private static void propogateVars(VarInfo[][] v, int pcfrom, int pcto) {
        int m = v.length;
        for (int j = 0; j < m; ++j) {
            v[j][pcto] = v[j][pcfrom];
        }
    }

    private void replaceTrivialPhiVariables() {
        for (BasicBlock b0 : this.blocklist) {
            for (int slot = 0; slot < this.prototype.maxstacksize; ++slot) {
                VarInfo vold = this.vars[slot][b0.pc0];
                VarInfo vnew = vold.resolvePhiVariableValues();
                if (vnew == null) continue;
                this.substituteVariable(slot, vold, vnew);
            }
        }
    }

    private void substituteVariable(int slot, VarInfo vold, VarInfo vnew) {
        int n = this.prototype.code.length;
        for (int i = 0; i < n; ++i) {
            this.replaceAll(this.vars[slot], this.vars[slot].length, vold, vnew);
        }
    }

    private void replaceAll(VarInfo[] v, int n, VarInfo vold, VarInfo vnew) {
        for (int i = 0; i < n; ++i) {
            if (v[i] != vold) continue;
            v[i] = vnew;
        }
    }

    private void findUpvalues() {
        int pc;
        int[] code = this.prototype.code;
        int n = code.length;
        String[] names = this.findInnerprotoNames();
        for (pc = 0; pc < n; ++pc) {
            if (Lua.GET_OPCODE((int)code[pc]) != 37) continue;
            int bx = Lua.GETARG_Bx((int)code[pc]);
            Prototype newp = this.prototype.p[bx];
            UpvalInfo[] newu = new UpvalInfo[newp.upvalues.length];
            String newname = this.name + "$" + names[bx];
            for (int j = 0; j < newp.upvalues.length; ++j) {
                Upvaldesc u = newp.upvalues[j];
                newu[j] = u.instack ? this.findOpenUp(pc, u.idx) : this.upvals[u.idx];
            }
            this.subprotos[bx] = new ProtoInfo(newp, newname, newu);
        }
        for (pc = 0; pc < n; ++pc) {
            if (Lua.GET_OPCODE((int)code[pc]) != 9) continue;
            this.upvals[Lua.GETARG_B((int)code[pc])].rw = true;
        }
    }

    private UpvalInfo findOpenUp(int pc, int slot) {
        if (this.openups[slot] == null) {
            this.openups[slot] = new UpvalInfo[this.prototype.code.length];
        }
        if (this.openups[slot][pc] != null) {
            return this.openups[slot][pc];
        }
        UpvalInfo u = new UpvalInfo(this, pc, slot);
        int n = this.prototype.code.length;
        for (int i = 0; i < n; ++i) {
            if (this.vars[slot][i] == null || this.vars[slot][i].upvalue != u) continue;
            this.openups[slot][i] = u;
        }
        return u;
    }

    public boolean isUpvalueAssign(int pc, int slot) {
        VarInfo v = pc < 0 ? this.params[slot] : this.vars[slot][pc];
        return v != null && v.upvalue != null && v.upvalue.rw;
    }

    public boolean isUpvalueCreate(int pc, int slot) {
        VarInfo v = pc < 0 ? this.params[slot] : this.vars[slot][pc];
        return v != null && v.upvalue != null && v.upvalue.rw && v.allocupvalue && pc == v.pc;
    }

    public boolean isUpvalueRefer(int pc, int slot) {
        if (pc > 0 && this.vars[slot][pc] != null && this.vars[slot][pc].pc == pc && this.vars[slot][pc - 1] != null) {
            --pc;
        }
        VarInfo v = pc < 0 ? this.params[slot] : this.vars[slot][pc];
        return v != null && v.upvalue != null && v.upvalue.rw;
    }

    public boolean isInitialValueUsed(int slot) {
        VarInfo v = this.params[slot];
        return v.isreferenced;
    }

    public boolean isReadWriteUpvalue(UpvalInfo u) {
        return u.rw;
    }

    private String[] findInnerprotoNames() {
        if (this.prototype.p.length <= 0) {
            return null;
        }
        String[] names = new String[this.prototype.p.length];
        Hashtable<String, Boolean> used = new Hashtable<String, Boolean>();
        int[] code = this.prototype.code;
        int n = code.length;
        for (int pc = 0; pc < n; ++pc) {
            if (Lua.GET_OPCODE((int)code[pc]) != 37) continue;
            int bx = Lua.GETARG_Bx((int)code[pc]);
            String name = null;
            int i = code[pc + 1];
            switch (Lua.GET_OPCODE((int)i)) {
                case 8: 
                case 10: {
                    int b = Lua.GETARG_B((int)i);
                    if (!Lua.ISK((int)b)) break;
                    name = this.prototype.k[b & 0xFF].tojstring();
                    break;
                }
                case 9: {
                    int b = Lua.GETARG_B((int)i);
                    LuaString s = this.prototype.upvalues[b].name;
                    if (s == null) break;
                    name = s.tojstring();
                    break;
                }
                default: {
                    int a = Lua.GETARG_A((int)code[pc]);
                    LuaString s = this.prototype.getlocalname(a + 1, pc + 1);
                    if (s == null) break;
                    name = s.tojstring();
                }
            }
            String string = name = name != null ? ProtoInfo.toJavaClassPart(name) : String.valueOf(bx);
            if (used.containsKey(name)) {
                String basename = name;
                int count = 1;
                while (used.containsKey(name = basename + '$' + count++)) {
                }
            }
            used.put(name, Boolean.TRUE);
            names[bx] = name;
        }
        return names;
    }

    private static String toJavaClassPart(String s) {
        int n = s.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sb.append(Character.isJavaIdentifierPart(s.charAt(i)) ? s.charAt(i) : (char)'_');
        }
        return sb.toString();
    }
}

