/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.JavaBuilder;
import org.luaj.vm2.luajc.ProtoInfo;

public class JavaGen {
    public final String classname;
    public final byte[] bytecode;
    public final JavaGen[] inners;

    public JavaGen(Prototype p, String classname, String filename, boolean genmain) {
        this(new ProtoInfo(p, classname), classname, filename, genmain);
    }

    private JavaGen(ProtoInfo pi, String classname, String filename, boolean genmain) {
        this.classname = classname;
        JavaBuilder builder = new JavaBuilder(pi, classname, filename);
        this.scanInstructions(pi, classname, builder);
        for (int i = 0; i < pi.prototype.locvars.length; ++i) {
            LocVars l = pi.prototype.locvars[i];
            builder.setVarStartEnd(i, l.startpc, l.endpc, l.varname.tojstring());
        }
        this.bytecode = builder.completeClass(genmain);
        if (pi.subprotos != null) {
            int n = pi.subprotos.length;
            this.inners = new JavaGen[n];
            for (int i = 0; i < n; ++i) {
                this.inners[i] = new JavaGen(pi.subprotos[i], pi.subprotos[i].name, filename, false);
            }
        } else {
            this.inners = null;
        }
    }

    private void scanInstructions(ProtoInfo pi, String classname, JavaBuilder builder) {
        Prototype p = pi.prototype;
        int vresultbase = -1;
        for (BasicBlock b0 : pi.blocklist) {
            for (int slot = 0; slot < p.maxstacksize; ++slot) {
                int pc = b0.pc0;
                boolean c = pi.isUpvalueCreate(pc, slot);
                if (!c || !pi.vars[slot][pc].isPhiVar()) continue;
                builder.convertToUpvalue(pc, slot);
            }
            for (int pc = b0.pc0; pc <= b0.pc1; ++pc) {
                int pc0 = pc;
                int ins = p.code[pc];
                int line = pc < p.lineinfo.length ? p.lineinfo[pc] : -1;
                int o = Lua.GET_OPCODE((int)ins);
                int a = Lua.GETARG_A((int)ins);
                int bx = Lua.GETARG_Bx((int)ins);
                int sbx = Lua.GETARG_sBx((int)ins);
                int c = Lua.GETARG_C((int)ins);
                block0 : switch (o) {
                    case 5: {
                        int b;
                        builder.loadUpvalue(b);
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 9: {
                        int b;
                        builder.storeUpvalue(pc, b, a);
                        break;
                    }
                    case 11: {
                        int b;
                        builder.newTable(b, c);
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 0: {
                        int b;
                        builder.loadLocal(pc, b);
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: {
                        int b;
                        builder.loadLocal(pc, b);
                        builder.unaryop(o);
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 1: {
                        builder.loadConstant(p.k[bx]);
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 4: {
                        int b;
                        builder.loadNil();
                        for (b = Lua.GETARG_B((int)ins); b >= 0; --b) {
                            if (b > 0) {
                                builder.dup();
                            }
                            builder.storeLocal(pc, a);
                            ++a;
                        }
                        break;
                    }
                    case 6: {
                        int b;
                        builder.loadUpvalue(b);
                        this.loadLocalOrConstant(p, builder, pc, c);
                        builder.getTable();
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 7: {
                        int b;
                        builder.loadLocal(pc, b);
                        this.loadLocalOrConstant(p, builder, pc, c);
                        builder.getTable();
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 8: {
                        int b;
                        builder.loadUpvalue(a);
                        this.loadLocalOrConstant(p, builder, pc, b);
                        this.loadLocalOrConstant(p, builder, pc, c);
                        builder.setTable();
                        break;
                    }
                    case 10: {
                        int b;
                        builder.loadLocal(pc, a);
                        this.loadLocalOrConstant(p, builder, pc, b);
                        this.loadLocalOrConstant(p, builder, pc, c);
                        builder.setTable();
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        int b;
                        this.loadLocalOrConstant(p, builder, pc, b);
                        this.loadLocalOrConstant(p, builder, pc, c);
                        builder.binaryop(o);
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 12: {
                        int b;
                        builder.loadLocal(pc, b);
                        builder.dup();
                        builder.storeLocal(pc, a + 1);
                        this.loadLocalOrConstant(p, builder, pc, c);
                        builder.getTable();
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 22: {
                        int k;
                        int b;
                        for (k = b; k <= c; ++k) {
                            builder.loadLocal(pc, k);
                        }
                        if (c > b + 1) {
                            builder.tobuffer();
                            k = c;
                            while (--k >= b) {
                                builder.concatbuffer();
                            }
                            builder.tovalue();
                        } else {
                            builder.concatvalue();
                        }
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 3: {
                        int b;
                        builder.loadBoolean(b != 0);
                        builder.storeLocal(pc, a);
                        if (c == 0) break;
                        builder.addBranch(pc, 1, pc + 2);
                        break;
                    }
                    case 23: {
                        int i;
                        if (a > 0) {
                            for (i = a - 1; i < pi.openups.length; ++i) {
                                builder.closeUpvalue(pc, i);
                            }
                        }
                        builder.addBranch(pc, 1, pc + 1 + sbx);
                        break;
                    }
                    case 24: 
                    case 25: 
                    case 26: {
                        int b;
                        this.loadLocalOrConstant(p, builder, pc, b);
                        this.loadLocalOrConstant(p, builder, pc, c);
                        builder.compareop(o);
                        builder.addBranch(pc, a != 0 ? 3 : 2, pc + 2);
                        break;
                    }
                    case 27: {
                        builder.loadLocal(pc, a);
                        builder.toBoolean();
                        builder.addBranch(pc, c != 0 ? 3 : 2, pc + 2);
                        break;
                    }
                    case 28: {
                        int b;
                        builder.loadLocal(pc, b);
                        builder.toBoolean();
                        builder.addBranch(pc, c != 0 ? 3 : 2, pc + 2);
                        builder.loadLocal(pc, b);
                        builder.storeLocal(pc, a);
                        break;
                    }
                    case 29: {
                        boolean useinvoke;
                        int b;
                        builder.loadLocal(pc, a);
                        int narg = b - 1;
                        switch (narg) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                for (int i = 1; i < b; ++i) {
                                    builder.loadLocal(pc, a + i);
                                }
                                break;
                            }
                            default: {
                                builder.newVarargs(pc, a + 1, b - 1);
                                narg = -1;
                                break;
                            }
                            case -1: {
                                this.loadVarargResults(builder, pc, a + 1, vresultbase);
                                narg = -1;
                            }
                        }
                        boolean bl = useinvoke = narg < 0 || c < 1 || c > 2;
                        if (useinvoke) {
                            builder.invoke(narg);
                        } else {
                            builder.call(narg);
                        }
                        switch (c) {
                            case 1: {
                                builder.pop();
                                break;
                            }
                            case 2: {
                                if (useinvoke) {
                                    builder.arg(1);
                                }
                                builder.storeLocal(pc, a);
                                break;
                            }
                            default: {
                                for (int i = 1; i < c; ++i) {
                                    if (i + 1 < c) {
                                        builder.dup();
                                    }
                                    builder.arg(i);
                                    builder.storeLocal(pc, a + i - 1);
                                }
                                break block0;
                            }
                            case 0: {
                                vresultbase = a;
                                builder.storeVarresult();
                                break;
                            }
                        }
                        break;
                    }
                    case 30: {
                        int b;
                        builder.loadLocal(pc, a);
                        switch (b) {
                            case 1: {
                                builder.loadNone();
                                break;
                            }
                            case 2: {
                                builder.loadLocal(pc, a + 1);
                                break;
                            }
                            default: {
                                builder.newVarargs(pc, a + 1, b - 1);
                                break;
                            }
                            case 0: {
                                this.loadVarargResults(builder, pc, a + 1, vresultbase);
                            }
                        }
                        builder.newTailcallVarargs();
                        builder.areturn();
                        break;
                    }
                    case 31: {
                        int b;
                        if (c == 1) {
                            builder.loadNone();
                        } else {
                            switch (b) {
                                case 0: {
                                    this.loadVarargResults(builder, pc, a, vresultbase);
                                    break;
                                }
                                case 1: {
                                    builder.loadNone();
                                    break;
                                }
                                case 2: {
                                    builder.loadLocal(pc, a);
                                    break;
                                }
                                default: {
                                    builder.newVarargs(pc, a, b - 1);
                                }
                            }
                        }
                        builder.areturn();
                        break;
                    }
                    case 33: {
                        builder.loadLocal(pc, a);
                        builder.loadLocal(pc, a + 2);
                        builder.binaryop(14);
                        builder.storeLocal(pc, a);
                        builder.addBranch(pc, 1, pc + 1 + sbx);
                        break;
                    }
                    case 32: {
                        builder.loadLocal(pc, a);
                        builder.loadLocal(pc, a + 2);
                        builder.binaryop(13);
                        builder.dup();
                        builder.dup();
                        builder.storeLocal(pc, a);
                        builder.storeLocal(pc, a + 3);
                        builder.loadLocal(pc, a + 1);
                        builder.loadLocal(pc, a + 2);
                        builder.testForLoop();
                        builder.addBranch(pc, 2, pc + 1 + sbx);
                        break;
                    }
                    case 34: {
                        int i;
                        builder.loadLocal(pc, a);
                        builder.loadLocal(pc, a + 1);
                        builder.loadLocal(pc, a + 2);
                        builder.invoke(2);
                        for (i = 1; i <= c; ++i) {
                            if (i < c) {
                                builder.dup();
                            }
                            builder.arg(i);
                            builder.storeLocal(pc, a + 2 + i);
                        }
                        break;
                    }
                    case 35: {
                        builder.loadLocal(pc, a + 1);
                        builder.dup();
                        builder.storeLocal(pc, a);
                        builder.isNil();
                        builder.addBranch(pc, 3, pc + 1 + sbx);
                        break;
                    }
                    case 36: {
                        int b;
                        int index0 = (c - 1) * 50 + 1;
                        builder.loadLocal(pc, a);
                        if (b == 0) {
                            int nstack = vresultbase - (a + 1);
                            if (nstack > 0) {
                                builder.setlistStack(pc, a + 1, index0, nstack);
                                index0 += nstack;
                            }
                            builder.setlistVarargs(index0, vresultbase);
                            break;
                        }
                        builder.setlistStack(pc, a + 1, index0, b);
                        builder.pop();
                        break;
                    }
                    case 37: {
                        Prototype newp = p.p[bx];
                        int nup = newp.upvalues.length;
                        String protoname = pi.subprotos[bx].name;
                        builder.closureCreate(protoname);
                        if (nup > 0) {
                            builder.dup();
                        }
                        builder.storeLocal(pc, a);
                        for (int up = 0; up < nup; ++up) {
                            if (up + 1 < nup) {
                                builder.dup();
                            }
                            Upvaldesc u = newp.upvalues[up];
                            if (u.instack) {
                                builder.closureInitUpvalueFromLocal(protoname, up, pc, u.idx);
                                continue;
                            }
                            builder.closureInitUpvalueFromUpvalue(protoname, up, u.idx);
                        }
                        break;
                    }
                    case 38: {
                        int b;
                        if (b == 0) {
                            builder.loadVarargs();
                            builder.storeVarresult();
                            vresultbase = a;
                            break;
                        }
                        for (int i = 1; i < b; ++i) {
                            builder.loadVarargs(i);
                            builder.storeLocal(pc, a);
                            ++a;
                        }
                        break;
                    }
                }
                builder.onEndOfLuaInstruction(pc0, line);
            }
        }
    }

    private void loadVarargResults(JavaBuilder builder, int pc, int a, int vresultbase) {
        if (vresultbase <= a) {
            builder.loadVarresult();
            builder.subargs(a + 1 - vresultbase);
        } else if (vresultbase == a) {
            builder.loadVarresult();
        } else {
            builder.newVarargsVarresult(pc, a, vresultbase - a);
        }
    }

    private void loadLocalOrConstant(Prototype p, JavaBuilder builder, int pc, int borc) {
        if (borc <= 255) {
            builder.loadLocal(pc, borc);
        } else {
            builder.loadConstant(p.k[borc & 0xFF]);
        }
    }
}

