/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.util.Vector;
import org.luaj.vm2.Lua;
import org.luaj.vm2.Prototype;

public class BasicBlock {
    int pc0;
    int pc1;
    BasicBlock[] prev;
    BasicBlock[] next;
    boolean islive;

    public BasicBlock(Prototype p, int pc0) {
        this.pc0 = this.pc1 = pc0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pc0 + 1 + "-" + (this.pc1 + 1) + (this.prev != null ? "  prv: " + this.str(this.prev, 1) : "") + (this.next != null ? "  nxt: " + this.str(this.next, 0) : "") + "\n");
        return sb.toString();
    }

    private String str(BasicBlock[] b, int p) {
        if (b == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int n = b.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.valueOf(p == 1 ? b[i].pc1 + 1 : b[i].pc0 + 1));
        }
        sb.append(")");
        return sb.toString();
    }

    public static BasicBlock[] findBasicBlocks(Prototype p) {
        int n = p.code.length;
        boolean[] isbeg = new boolean[n];
        boolean[] isend = new boolean[n];
        isbeg[0] = true;
        MarkAndMergeVisitor bv = new MarkAndMergeVisitor(isbeg, isend);
        BasicBlock.visitBranches(p, bv);
        BasicBlock.visitBranches(p, bv);
        BasicBlock[] blocks = new BasicBlock[n];
        for (int i = 0; i < n; ++i) {
            BasicBlock b;
            isbeg[i] = true;
            blocks[i] = b = new BasicBlock(p, i);
            while (!isend[i] && i + 1 < n && !isbeg[i + 1]) {
                b.pc1 = ++i;
                blocks[b.pc1] = b;
            }
        }
        int[] nnext = new int[n];
        int[] nprev = new int[n];
        BasicBlock.visitBranches(p, new CountPrevNextVistor(isbeg, nnext, nprev));
        BasicBlock.visitBranches(p, new AllocAndXRefVisitor(isbeg, nnext, nprev, blocks));
        return blocks;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void visitBranches(Prototype p, BranchVisitor visitor) {
        int[] code = p.code;
        int n = code.length;
        int i = 0;
        while (true) {
            block12: {
                if (i >= n) {
                    return;
                }
                int ins = code[i];
                switch (Lua.GET_OPCODE((int)ins)) {
                    case 3: {
                        if (0 == Lua.GETARG_C((int)ins)) break;
                        if (Lua.GET_OPCODE((int)code[i + 1]) == 23) {
                            throw new IllegalArgumentException("OP_LOADBOOL followed by jump at " + i);
                        }
                        visitor.visitBranch(i, i + 2);
                        break block12;
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: {
                        if (Lua.GET_OPCODE((int)code[i + 1]) != 23) {
                            throw new IllegalArgumentException("test not followed by jump at " + i);
                        }
                        int sbx = Lua.GETARG_sBx((int)code[i + 1]);
                        int j = ++i + sbx + 1;
                        visitor.visitBranch(i, j);
                        visitor.visitBranch(i, i + 1);
                        break block12;
                    }
                    case 32: 
                    case 35: {
                        int sbx = Lua.GETARG_sBx((int)ins);
                        int j = i + sbx + 1;
                        visitor.visitBranch(i, j);
                        visitor.visitBranch(i, i + 1);
                        break block12;
                    }
                    case 23: 
                    case 33: {
                        int sbx = Lua.GETARG_sBx((int)ins);
                        int j = i + sbx + 1;
                        visitor.visitBranch(i, j);
                        break block12;
                    }
                    case 30: 
                    case 31: {
                        visitor.visitReturn(i);
                        break block12;
                    }
                }
                if (i + 1 < n && visitor.isbeg[i + 1]) {
                    visitor.visitBranch(i, i + 1);
                }
            }
            ++i;
        }
    }

    public static BasicBlock[] findLiveBlocks(BasicBlock[] blocks) {
        int i;
        Vector<BasicBlock> next = new Vector<BasicBlock>();
        next.addElement(blocks[0]);
        while (!next.isEmpty()) {
            int n;
            BasicBlock b = (BasicBlock)next.elementAt(0);
            next.removeElementAt(0);
            if (b.islive) continue;
            b.islive = true;
            int n2 = n = b.next != null ? b.next.length : 0;
            for (i = 0; i < n; ++i) {
                if (b.next[i].islive) continue;
                next.addElement(b.next[i]);
            }
        }
        Vector<BasicBlock> list = new Vector<BasicBlock>();
        i = 0;
        while (i < blocks.length) {
            if (blocks[i].islive) {
                list.addElement(blocks[i]);
            }
            i = blocks[i].pc1 + 1;
        }
        Object[] array = new BasicBlock[list.size()];
        list.copyInto(array);
        return array;
    }

    public static abstract class BranchVisitor {
        final boolean[] isbeg;

        public BranchVisitor(boolean[] isbeg) {
            this.isbeg = isbeg;
        }

        public void visitBranch(int frompc, int topc) {
        }

        public void visitReturn(int atpc) {
        }
    }

    private static final class MarkAndMergeVisitor
    extends BranchVisitor {
        private final boolean[] isend;

        private MarkAndMergeVisitor(boolean[] isbeg, boolean[] isend) {
            super(isbeg);
            this.isend = isend;
        }

        @Override
        public void visitBranch(int pc0, int pc1) {
            this.isend[pc0] = true;
            this.isbeg[pc1] = true;
        }

        @Override
        public void visitReturn(int pc) {
            this.isend[pc] = true;
        }
    }

    private static final class CountPrevNextVistor
    extends BranchVisitor {
        private final int[] nnext;
        private final int[] nprev;

        private CountPrevNextVistor(boolean[] isbeg, int[] nnext, int[] nprev) {
            super(isbeg);
            this.nnext = nnext;
            this.nprev = nprev;
        }

        @Override
        public void visitBranch(int pc0, int pc1) {
            int n = pc0;
            this.nnext[n] = this.nnext[n] + 1;
            int n2 = pc1;
            this.nprev[n2] = this.nprev[n2] + 1;
        }
    }

    private static final class AllocAndXRefVisitor
    extends BranchVisitor {
        private final int[] nnext;
        private final int[] nprev;
        private final BasicBlock[] blocks;

        private AllocAndXRefVisitor(boolean[] isbeg, int[] nnext, int[] nprev, BasicBlock[] blocks) {
            super(isbeg);
            this.nnext = nnext;
            this.nprev = nprev;
            this.blocks = blocks;
        }

        @Override
        public void visitBranch(int pc0, int pc1) {
            if (this.blocks[pc0].next == null) {
                this.blocks[pc0].next = new BasicBlock[this.nnext[pc0]];
            }
            if (this.blocks[pc1].prev == null) {
                this.blocks[pc1].prev = new BasicBlock[this.nprev[pc1]];
            }
            int n = pc0;
            int n2 = this.nnext[n] - 1;
            this.nnext[n] = n2;
            this.blocks[pc0].next[n2] = this.blocks[pc1];
            int n3 = pc1;
            int n4 = this.nprev[n3] - 1;
            this.nprev[n3] = n4;
            this.blocks[pc1].prev[n4] = this.blocks[pc0];
        }
    }
}

