/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;
import org.luaj.vm2.lib.TwoArgFunction;

public class JseMathLib
extends MathLib {
    public LuaValue call(LuaValue modname, LuaValue env) {
        super.call(modname, env);
        LuaValue math = env.get("math");
        math.set("acos", (LuaValue)new acos());
        math.set("asin", (LuaValue)new asin());
        math.set("atan", (LuaValue)new atan());
        math.set("atan2", (LuaValue)new atan2());
        math.set("cosh", (LuaValue)new cosh());
        math.set("exp", (LuaValue)new exp());
        math.set("log", (LuaValue)new log());
        math.set("pow", (LuaValue)new pow());
        math.set("sinh", (LuaValue)new sinh());
        math.set("tanh", (LuaValue)new tanh());
        return math;
    }

    public double dpow_lib(double a, double b) {
        return Math.pow(a, b);
    }

    static final class tanh
    extends MathLib.UnaryOp {
        tanh() {
        }

        protected double call(double d) {
            return Math.tanh(d);
        }
    }

    static final class sinh
    extends MathLib.UnaryOp {
        sinh() {
        }

        protected double call(double d) {
            return Math.sinh(d);
        }
    }

    static final class pow
    extends MathLib.BinaryOp {
        pow() {
        }

        protected double call(double x, double y) {
            return Math.pow(x, y);
        }
    }

    static final class log
    extends TwoArgFunction {
        log() {
        }

        public LuaValue call(LuaValue x, LuaValue base) {
            double nat = Math.log(x.checkdouble());
            double b = base.optdouble(Math.E);
            if (b != Math.E) {
                nat /= Math.log(b);
            }
            return log.valueOf((double)nat);
        }
    }

    static final class exp
    extends MathLib.UnaryOp {
        exp() {
        }

        protected double call(double d) {
            return Math.exp(d);
        }
    }

    static final class cosh
    extends MathLib.UnaryOp {
        cosh() {
        }

        protected double call(double d) {
            return Math.cosh(d);
        }
    }

    static final class atan2
    extends TwoArgFunction {
        atan2() {
        }

        public LuaValue call(LuaValue x, LuaValue y) {
            return atan2.valueOf((double)Math.atan2(x.checkdouble(), y.checkdouble()));
        }
    }

    static final class atan
    extends TwoArgFunction {
        atan() {
        }

        public LuaValue call(LuaValue x, LuaValue y) {
            return atan.valueOf((double)Math.atan2(x.checkdouble(), y.optdouble(1.0)));
        }
    }

    static final class asin
    extends MathLib.UnaryOp {
        asin() {
        }

        protected double call(double d) {
            return Math.asin(d);
        }
    }

    static final class acos
    extends MathLib.UnaryOp {
        acos() {
        }

        protected double call(double d) {
            return Math.acos(d);
        }
    }
}

