/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.lib.IoLib;

public class JseIoLib
extends IoLib {
    protected IoLib.File wrapStdin() throws IOException {
        return new StdinFile();
    }

    protected IoLib.File wrapStdout() throws IOException {
        return new StdoutFile(1);
    }

    protected IoLib.File wrapStderr() throws IOException {
        return new StdoutFile(2);
    }

    protected IoLib.File openFile(String filename, boolean readMode, boolean appendMode, boolean updateMode, boolean binaryMode) throws IOException {
        RandomAccessFile f = new RandomAccessFile(filename, readMode ? "r" : "rw");
        if (appendMode) {
            f.seek(f.length());
        } else if (!readMode) {
            f.setLength(0L);
        }
        return new FileImpl(f);
    }

    protected IoLib.File openProgram(String prog, String mode) throws IOException {
        Process p = Runtime.getRuntime().exec(prog);
        return "w".equals(mode) ? new FileImpl(p.getOutputStream()) : new FileImpl(p.getInputStream());
    }

    protected IoLib.File tmpFile() throws IOException {
        File f = File.createTempFile(".luaj", "bin");
        f.deleteOnExit();
        return new FileImpl(new RandomAccessFile(f, "rw"));
    }

    private static void notimplemented() {
        throw new LuaError("not implemented");
    }

    private final class StdinFile
    extends IoLib.File {
        private StdinFile() {
            super((IoLib)JseIoLib.this);
        }

        public String tojstring() {
            return "file (" + ((Object)((Object)this)).hashCode() + ")";
        }

        public void write(LuaString string) throws IOException {
        }

        public void flush() throws IOException {
        }

        public boolean isstdfile() {
            return true;
        }

        public void close() throws IOException {
        }

        public boolean isclosed() {
            return false;
        }

        public int seek(String option, int bytecount) throws IOException {
            return 0;
        }

        public void setvbuf(String mode, int size) {
        }

        public int remaining() throws IOException {
            return -1;
        }

        public int peek() throws IOException, EOFException {
            ((JseIoLib)JseIoLib.this).globals.STDIN.mark(1);
            int c = ((JseIoLib)JseIoLib.this).globals.STDIN.read();
            ((JseIoLib)JseIoLib.this).globals.STDIN.reset();
            return c;
        }

        public int read() throws IOException, EOFException {
            return ((JseIoLib)JseIoLib.this).globals.STDIN.read();
        }

        public int read(byte[] bytes, int offset, int length) throws IOException {
            return ((JseIoLib)JseIoLib.this).globals.STDIN.read(bytes, offset, length);
        }
    }

    private final class StdoutFile
    extends IoLib.File {
        private final int file_type;

        private StdoutFile(int file_type) {
            super((IoLib)JseIoLib.this);
            this.file_type = file_type;
        }

        public String tojstring() {
            return "file (" + ((Object)((Object)this)).hashCode() + ")";
        }

        private PrintStream getPrintStream() {
            return this.file_type == 2 ? ((JseIoLib)JseIoLib.this).globals.STDERR : ((JseIoLib)JseIoLib.this).globals.STDOUT;
        }

        public void write(LuaString string) throws IOException {
            this.getPrintStream().write(string.m_bytes, string.m_offset, string.m_length);
        }

        public void flush() throws IOException {
            this.getPrintStream().flush();
        }

        public boolean isstdfile() {
            return true;
        }

        public void close() throws IOException {
        }

        public boolean isclosed() {
            return false;
        }

        public int seek(String option, int bytecount) throws IOException {
            return 0;
        }

        public void setvbuf(String mode, int size) {
        }

        public int remaining() throws IOException {
            return 0;
        }

        public int peek() throws IOException, EOFException {
            return 0;
        }

        public int read() throws IOException, EOFException {
            return 0;
        }

        public int read(byte[] bytes, int offset, int length) throws IOException {
            return 0;
        }
    }

    private final class FileImpl
    extends IoLib.File {
        private final RandomAccessFile file;
        private final InputStream is;
        private final OutputStream os;
        private boolean closed;
        private boolean nobuffer;

        private FileImpl(RandomAccessFile file, InputStream is, OutputStream os) {
            super((IoLib)JseIoLib.this);
            this.closed = false;
            this.nobuffer = false;
            this.file = file;
            this.is = is != null ? (is.markSupported() ? is : new BufferedInputStream(is)) : null;
            this.os = os;
        }

        private FileImpl(RandomAccessFile f) {
            this(f, null, null);
        }

        private FileImpl(InputStream i) {
            this(null, i, null);
        }

        private FileImpl(OutputStream o) {
            this(null, null, o);
        }

        public String tojstring() {
            return "file (" + (this.closed ? "closed" : String.valueOf(((Object)((Object)this)).hashCode())) + ")";
        }

        public boolean isstdfile() {
            return this.file == null;
        }

        public void close() throws IOException {
            this.closed = true;
            if (this.file != null) {
                this.file.close();
            }
        }

        public void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        public void write(LuaString s) throws IOException {
            if (this.os != null) {
                this.os.write(s.m_bytes, s.m_offset, s.m_length);
            } else if (this.file != null) {
                this.file.write(s.m_bytes, s.m_offset, s.m_length);
            } else {
                JseIoLib.notimplemented();
            }
            if (this.nobuffer) {
                this.flush();
            }
        }

        public boolean isclosed() {
            return this.closed;
        }

        public int seek(String option, int pos) throws IOException {
            if (this.file != null) {
                if ("set".equals(option)) {
                    this.file.seek(pos);
                } else if ("end".equals(option)) {
                    this.file.seek(this.file.length() + (long)pos);
                } else {
                    this.file.seek(this.file.getFilePointer() + (long)pos);
                }
                return (int)this.file.getFilePointer();
            }
            JseIoLib.notimplemented();
            return 0;
        }

        public void setvbuf(String mode, int size) {
            this.nobuffer = "no".equals(mode);
        }

        public int remaining() throws IOException {
            return this.file != null ? (int)(this.file.length() - this.file.getFilePointer()) : -1;
        }

        public int peek() throws IOException {
            if (this.is != null) {
                this.is.mark(1);
                int c = this.is.read();
                this.is.reset();
                return c;
            }
            if (this.file != null) {
                long fp = this.file.getFilePointer();
                int c = this.file.read();
                this.file.seek(fp);
                return c;
            }
            JseIoLib.notimplemented();
            return 0;
        }

        public int read() throws IOException {
            if (this.is != null) {
                return this.is.read();
            }
            if (this.file != null) {
                return this.file.read();
            }
            JseIoLib.notimplemented();
            return 0;
        }

        public int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.file != null) {
                return this.file.read(bytes, offset, length);
            }
            if (this.is != null) {
                return this.is.read(bytes, offset, length);
            }
            JseIoLib.notimplemented();
            return length;
        }
    }
}

