/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.luaj.vm2.lib.jse.JavaMember;

class JavaConstructor
extends JavaMember {
    static final Map constructors = Collections.synchronizedMap(new HashMap());
    final Constructor constructor;

    static JavaConstructor forConstructor(Constructor c) {
        JavaConstructor j = (JavaConstructor)((Object)constructors.get(c));
        if (j == null) {
            j = new JavaConstructor(c);
            constructors.put(c, j);
        }
        return j;
    }

    public static LuaValue forConstructors(JavaConstructor[] array) {
        return new Overload(array);
    }

    private JavaConstructor(Constructor c) {
        super(c.getParameterTypes(), c.getModifiers());
        this.constructor = c;
    }

    public Varargs invoke(Varargs args) {
        Object[] a = this.convertArgs(args);
        try {
            return CoerceJavaToLua.coerce(this.constructor.newInstance(a));
        }
        catch (InvocationTargetException e) {
            throw new LuaError(e.getTargetException());
        }
        catch (Exception e) {
            return LuaValue.error((String)("coercion error " + e));
        }
    }

    static class Overload
    extends VarArgFunction {
        final JavaConstructor[] constructors;

        public Overload(JavaConstructor[] c) {
            this.constructors = c;
        }

        public Varargs invoke(Varargs args) {
            JavaConstructor best = null;
            int score = CoerceLuaToJava.SCORE_UNCOERCIBLE;
            for (JavaConstructor constructor : this.constructors) {
                int s = constructor.score(args);
                if (s >= score) continue;
                score = s;
                best = constructor;
                if (score == 0) break;
            }
            if (best == null) {
                LuaValue.error((String)"no coercible public method");
            }
            return best.invoke(args);
        }
    }
}

