/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.nio.charset.StandardCharsets;
import org.luaj.vm2.LuaString;

public class Str {
    private Str() {
    }

    public static LuaString quoteString(String image) {
        String s = image.substring(1, image.length() - 1);
        byte[] bytes = Str.unquote(s);
        return LuaString.valueUsing((byte[])bytes);
    }

    public static LuaString charString(String image) {
        String s = image.substring(1, image.length() - 1);
        byte[] bytes = Str.unquote(s);
        return LuaString.valueUsing((byte[])bytes);
    }

    public static LuaString longString(String image) {
        int i = image.indexOf(91, image.indexOf(91) + 1) + 1;
        String[] s = image.substring(i, image.length() - i).split("^\\r?\\n?", 2);
        byte[] b = s[s.length - 1].getBytes(StandardCharsets.UTF_8);
        return LuaString.valueUsing((byte[])b);
    }

    public static byte[] unquote(String s) {
        StringBuilder builder = new StringBuilder();
        char[] c = s.toCharArray();
        int n = c.length;
        for (int i = 0; i < n; ++i) {
            if (c[i] == '\\' && i < n - 1) {
                switch (c[++i]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int d = c[i++] - 48;
                        for (int j = 0; i < n && j < 2 && c[i] >= '0' && c[i] <= '9'; ++i, ++j) {
                            d = d * 10 + c[i] - 48;
                        }
                        builder.append((char)d);
                        --i;
                        break;
                    }
                    case 'a': {
                        builder.append('\u0007');
                        break;
                    }
                    case 'b': {
                        builder.append('\b');
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case 'v': {
                        builder.append('\u000b');
                        break;
                    }
                    case '\"': {
                        builder.append('\"');
                        break;
                    }
                    case '\'': {
                        builder.append('\'');
                        break;
                    }
                    case '\\': {
                        builder.append('\\');
                        break;
                    }
                    default: {
                        builder.append(c[i]);
                        break;
                    }
                }
                continue;
            }
            builder.append(c[i]);
        }
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }
}

