/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.luaj.vm2.Globals;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.luajc.LuaJC;

public class luajc {
    private static final String version = "Luaj 0.0 Copyright (C) 2012 luaj.org";
    private static final String usage = "usage: java -cp luaj-jse.jar,bcel-5.2.jar luajc [options] fileordir [, fileordir ...]\nAvailable options are:\n  -        process stdin\n  -s src\tsource directory\n  -d dir\tdestination directory\n  -p pkg\tpackage prefix to apply to all classes\n  -m\t\tgenerate main(String[]) function for JSE\n  -r\t\trecursively compile all\n  -l\t\tload classes to verify generated bytecode\n  -c enc  \tuse the supplied encoding 'enc' for input files\n  -v   \tverbose\n";
    private String srcdir = ".";
    private String destdir = ".";
    private boolean genmain = false;
    private boolean recurse = false;
    private boolean verbose = false;
    private boolean loadclasses = false;
    private String encoding = null;
    private String pkgprefix = null;
    private final List files = new ArrayList();
    private final Globals globals;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        new luajc(args);
    }

    private luajc(String[] args) throws IOException {
        ArrayList<String> seeds = new ArrayList<String>();
        block10: for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                seeds.add(args[i]);
                continue;
            }
            switch (args[i].charAt(1)) {
                case 's': {
                    if (++i >= args.length) {
                        luajc.usageExit();
                    }
                    this.srcdir = args[i];
                    continue block10;
                }
                case 'd': {
                    if (++i >= args.length) {
                        luajc.usageExit();
                    }
                    this.destdir = args[i];
                    continue block10;
                }
                case 'l': {
                    this.loadclasses = true;
                    continue block10;
                }
                case 'p': {
                    if (++i >= args.length) {
                        luajc.usageExit();
                    }
                    this.pkgprefix = args[i];
                    continue block10;
                }
                case 'm': {
                    this.genmain = true;
                    continue block10;
                }
                case 'r': {
                    this.recurse = true;
                    continue block10;
                }
                case 'c': {
                    if (++i >= args.length) {
                        luajc.usageExit();
                    }
                    this.encoding = args[i];
                    continue block10;
                }
                case 'v': {
                    this.verbose = true;
                    continue block10;
                }
                default: {
                    luajc.usageExit();
                }
            }
        }
        if (this.verbose) {
            System.out.println(version);
            System.out.println("srcdir: " + this.srcdir);
            System.out.println("destdir: " + this.destdir);
            System.out.println("files: " + seeds);
            System.out.println("recurse: " + this.recurse);
        }
        if (seeds.size() <= 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (Object e : seeds) {
            this.collectFiles(this.srcdir + "/" + e);
        }
        if (this.files.size() <= 0) {
            System.err.println("no files found in " + seeds);
            System.exit(-1);
        }
        this.globals = JsePlatform.standardGlobals();
        for (Object e : this.files) {
            this.processFile((InputFile)e);
        }
    }

    private void collectFiles(String path) {
        File dir;
        File f = new File(path);
        if (f.isDirectory() && this.recurse) {
            this.scandir(f, this.pkgprefix);
        } else if (f.isFile() && (dir = f.getAbsoluteFile().getParentFile()) != null) {
            this.scanfile(dir, f, this.pkgprefix);
        }
    }

    private void scandir(File dir, String javapackage) {
        File[] f;
        for (File element : f = dir.listFiles()) {
            this.scanfile(dir, element, javapackage);
        }
    }

    private void scanfile(File dir, File f, String javapackage) {
        if (f.exists()) {
            if (f.isDirectory() && this.recurse) {
                this.scandir(f, javapackage != null ? javapackage + "." + f.getName() : f.getName());
            } else if (f.isFile() && f.getName().endsWith(".lua")) {
                this.files.add(new InputFile(dir, f, javapackage));
            }
        }
    }

    private void processFile(InputFile inf) {
        inf.outdir.mkdirs();
        try {
            if (this.verbose) {
                System.out.println("chunk=" + inf.luachunkname + " srcfile=" + inf.srcfilename);
            }
            FileInputStream fis = new FileInputStream(inf.infile);
            Hashtable t = this.encoding != null ? LuaJC.instance.compileAll(new InputStreamReader((InputStream)fis, this.encoding), inf.luachunkname, inf.srcfilename, this.globals, this.genmain) : LuaJC.instance.compileAll(fis, inf.luachunkname, inf.srcfilename, this.globals, this.genmain);
            fis.close();
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                byte[] bytes = (byte[])t.get(key);
                if (key.indexOf(47) >= 0) {
                    String d = (this.destdir != null ? this.destdir + "/" : "") + key.substring(0, key.lastIndexOf(47));
                    new File(d).mkdirs();
                }
                String destpath = (this.destdir != null ? this.destdir + "/" : "") + key + ".class";
                if (this.verbose) {
                    System.out.println("  " + destpath + " (" + bytes.length + " bytes)");
                }
                FileOutputStream fos = new FileOutputStream(destpath);
                fos.write(bytes);
                fos.close();
            }
            if (this.loadclasses) {
                LocalClassLoader loader = new LocalClassLoader(t);
                Enumeration e2 = t.keys();
                while (e2.hasMoreElements()) {
                    String classname = (String)e2.nextElement();
                    try {
                        Class<?> c = loader.loadClass(classname);
                        Object o = c.newInstance();
                        if (!this.verbose) continue;
                        System.out.println("    loaded " + classname + " as " + o);
                    }
                    catch (Exception ex) {
                        System.out.flush();
                        System.err.println("    failed to load " + classname + ": " + ex);
                        System.err.flush();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("    failed to load " + inf.srcfilename + ": " + e);
            e.printStackTrace(System.err);
            System.err.flush();
        }
    }

    class InputFile {
        public String luachunkname;
        public String srcfilename;
        public File infile;
        public File outdir;
        public String javapackage;

        public InputFile(File dir, File f, String javapackage) {
            this.infile = f;
            String subdir = javapackage != null ? javapackage.replace('.', '/') : null;
            String outdirpath = subdir != null ? luajc.this.destdir + "/" + subdir : luajc.this.destdir;
            this.javapackage = javapackage;
            this.srcfilename = (subdir != null ? subdir + "/" : "") + this.infile.getName();
            this.luachunkname = (subdir != null ? subdir + "/" : "") + this.infile.getName().substring(0, this.infile.getName().lastIndexOf(46));
            this.infile = f;
            this.outdir = new File(outdirpath);
        }
    }

    private static final class LocalClassLoader
    extends ClassLoader {
        private final Hashtable t;

        private LocalClassLoader(Hashtable t) {
            this.t = t;
        }

        public Class findClass(String classname) throws ClassNotFoundException {
            byte[] bytes = (byte[])this.t.get(classname);
            if (bytes != null) {
                return this.defineClass(classname, bytes, 0, bytes.length);
            }
            return super.findClass(classname);
        }
    }
}

