/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.gametest.infrastructure;

import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_4516;
import net.minecraft.class_4517;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PortingLibGameTestHelper
extends class_4516 {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TEN_SECONDS = 200;
    public static final int FIFTEEN_SECONDS = 300;
    public static final int TWENTY_SECONDS = 400;

    public PortingLibGameTestHelper(class_4517 test) {
        super(test);
    }

    public void flipBlock(class_2338 pos) {
        class_2680 original = this.method_35980(pos);
        if (!original.method_28498((class_2769)class_2741.field_12525)) {
            this.method_35995("FACING property not in block: " + class_7923.field_41175.method_10206((Object)original.method_26204()));
        }
        class_2350 facing = (class_2350)original.method_11654((class_2769)class_2741.field_12525);
        class_2680 reversed = (class_2680)original.method_11657((class_2769)class_2741.field_12525, (Comparable)facing.method_10153());
        this.method_35986(pos, reversed);
    }

    public void powerLever(class_2338 pos) {
        this.method_35972(class_2246.field_10363, pos);
        if (!((Boolean)this.method_35980(pos).method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
            this.method_36039(pos);
        }
    }

    public void unpowerLever(class_2338 pos) {
        this.method_35972(class_2246.field_10363, pos);
        if (((Boolean)this.method_35980(pos).method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
            this.method_36039(pos);
        }
    }

    public <T extends class_2586> T getBlockEntity(class_2591<T> type, class_2338 pos) {
        class_2591 actualType;
        class_2586 be = this.method_36014(pos);
        class_2591 class_25912 = actualType = be == null ? null : be.method_11017();
        if (actualType != type) {
            String actualId = actualType == null ? "null" : class_7923.field_41181.method_10221((Object)actualType).toString();
            String error = "Expected block entity at pos [%s] with type [%s], got [%s]".formatted(pos, class_7923.field_41181.method_10221(type), actualId);
            this.method_35995(error);
        }
        return (T)be;
    }

    public class_1542 spawnItem(class_2338 pos, class_1799 stack) {
        class_243 spawn = class_243.method_24953((class_2382)this.method_36052(pos));
        class_3218 level = this.method_35943();
        class_1542 item = new class_1542((class_1937)level, spawn.field_1352, spawn.field_1351, spawn.field_1350, stack, 0.0, 0.0, 0.0);
        level.method_8649((class_1297)item);
        return item;
    }

    public void spawnItems(class_2338 pos, class_1792 item, int amount) {
        while (amount > 0) {
            int toSpawn = Math.min(amount, item.method_7882());
            amount -= toSpawn;
            class_1799 stack = new class_1799((class_1935)item, toSpawn);
            this.spawnItem(pos, stack);
        }
    }

    public <T extends class_1297> T getFirstEntity(class_1299<T> type, class_2338 pos) {
        List<T> list = this.getEntitiesBetween(type, pos.method_10095().method_10078().method_10084(), pos.method_10072().method_10067().method_10074());
        if (list.isEmpty()) {
            this.method_35995("No entities at pos: " + pos);
        }
        return (T)((class_1297)list.get(0));
    }

    public <T extends class_1297> List<T> getEntitiesBetween(class_1299<T> type, class_2338 pos1, class_2338 pos2) {
        class_3341 box = class_3341.method_34390((class_2382)this.method_36052(pos1), (class_2382)this.method_36052(pos2));
        List entities = this.method_35943().method_18198(type, e -> box.method_14662((class_2382)e.method_24515()));
        return entities;
    }

    public Storage<FluidVariant> getFluidStorage(class_2338 pos) {
        Storage storage = (Storage)FluidStorage.SIDED.find((class_1937)this.method_35943(), this.method_36052(pos), null);
        if (storage == null) {
            this.method_35995("fluid storage not present");
        }
        return storage;
    }

    public Storage<ItemVariant> getItemStorage(class_2338 pos) {
        Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)this.method_35943(), this.method_36052(pos), null);
        if (storage == null) {
            this.method_35995("item storage not present");
        }
        return storage;
    }

    public Object2LongMap<class_1792> getItemContent(class_2338 pos) {
        Storage<ItemVariant> storage = this.getItemStorage(pos);
        Object2LongArrayMap map = new Object2LongArrayMap();
        for (StorageView view : storage.nonEmptyViews()) {
            class_1792 item = ((ItemVariant)view.getResource()).getItem();
            long existing = map.getLong((Object)item);
            map.put((Object)item, existing + view.getAmount());
        }
        return map;
    }

    public long getTotalItems(class_2338 pos) {
        Storage<ItemVariant> storage = this.getItemStorage(pos);
        long total = 0L;
        for (StorageView view : storage.nonEmptyViews()) {
            total += view.getAmount();
        }
        return total;
    }

    public void assertAnyContained(class_2338 pos, class_1792 ... items) {
        Storage<ItemVariant> storage = this.getItemStorage(pos);
        for (class_1792 item : items) {
            long extracted = storage.simulateExtract((Object)ItemVariant.of((class_1935)item), 1L, null);
            if (extracted == 0L) continue;
            return;
        }
        this.method_35995("No matching items " + Arrays.toString(items) + " found in handler at pos: " + pos);
    }

    public void assertContentPresent(Object2LongMap<class_1792> content, class_2338 pos) {
        Storage<ItemVariant> storage = this.getItemStorage(pos);
        content.forEach((item, expectedAmount) -> {
            long extracted = storage.simulateExtract((Object)ItemVariant.of((class_1935)item), expectedAmount.longValue(), null);
            if (extracted != expectedAmount) {
                this.method_35995("Storage missing " + item + ", only got " + extracted);
            }
        });
    }

    public void assertContainersEmpty(List<class_2338> positions) {
        for (class_2338 pos : positions) {
            this.method_36047(pos);
        }
    }

    public void method_36047(@NotNull class_2338 pos) {
        Storage<ItemVariant> storage = this.getItemStorage(pos);
        for (StorageView ignored : storage.nonEmptyViews()) {
            this.method_35995("Storage not empty");
        }
    }

    public void assertContainerContains(class_2338 pos, class_1935 item) {
        this.method_35983(pos, item.method_8389());
    }

    public void method_35983(@NotNull class_2338 pos, @NotNull class_1792 item) {
        this.assertContainerContains(pos, new class_1799((class_1935)item));
    }

    public void assertContainerContains(class_2338 pos, class_1799 item) {
        Storage<ItemVariant> storage = this.getItemStorage(pos);
        int count = item.method_7947();
        long extracted = storage.simulateExtract((Object)ItemVariant.of((class_1799)item), (long)count, null);
        if (extracted != (long)count) {
            this.method_35995("expected " + item + ", got " + extracted);
        }
    }

    public void assertSecondsPassed(int seconds) {
        if (this.method_36045() < (long)seconds * 20L) {
            this.method_35995("Waiting for %s seconds to pass".formatted(seconds));
        }
    }

    public long secondsPassed() {
        return this.method_36045() % 20L;
    }

    public void whenSecondsPassed(int seconds, Runnable run) {
        this.method_36003((long)seconds * 20L, run);
    }

    public void assertCloseEnoughTo(double value, double expected) {
        this.assertInRange(value, expected - 1.0, expected + 1.0);
    }

    public void assertInRange(double value, double min, double max) {
        if (value < min) {
            this.method_35995("Value %s below expected min of %s".formatted(value, min));
        }
        if (value > max) {
            this.method_35995("Value %s greater than expected max of %s".formatted(value, max));
        }
    }

    @Contract(value="_->fail")
    public void method_35995(@NotNull String exceptionMessage) {
        super.method_35995(exceptionMessage);
    }
}

