/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.gametest.infrastructure;

import io.github.fabricators_of_create.porting_lib.gametest.extensions.StructureBlockEntityExtensions;
import io.github.fabricators_of_create.porting_lib.gametest.infrastructure.CustomGameTestHelper;
import io.github.fabricators_of_create.porting_lib.gametest.infrastructure.GameTestGroup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_4516;
import net.minecraft.class_4517;
import net.minecraft.class_4525;
import net.minecraft.class_4529;
import net.minecraft.class_6302;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedTestFunction
extends class_4529 {
    @ApiStatus.Internal
    public static final Map<String, ExtendedTestFunction> NAMES_TO_FUNCTIONS = new HashMap<String, ExtendedTestFunction>();
    public final String fullyQualifiedName;
    public final String simpleName;
    private final UnaryOperator<class_4516> helperProcessor;

    protected ExtendedTestFunction(String fullyQualifiedName, String simpleName, UnaryOperator<class_4516> helperProcessor, String pBatchName, String pTestName, String pStructureName, class_2470 pRotation, int pMaxTicks, long pSetupTicks, boolean pRequired, int pRequiredSuccesses, int pMaxAttempts, Consumer<class_4516> pFunction) {
        super(pBatchName, pTestName, pStructureName, pRotation, pMaxTicks, pSetupTicks, pRequired, pRequiredSuccesses, pMaxAttempts, pFunction);
        this.fullyQualifiedName = fullyQualifiedName;
        this.simpleName = simpleName;
        NAMES_TO_FUNCTIONS.put(fullyQualifiedName, this);
        this.helperProcessor = helperProcessor;
    }

    @NotNull
    public String method_22296() {
        return this.simpleName;
    }

    @Nullable
    public static class_4529 of(Method method) {
        class_6302 gt = method.getAnnotation(class_6302.class);
        if (gt == null) {
            return null;
        }
        Class<?> owner = method.getDeclaringClass();
        String qualifiedName = owner.getSimpleName() + "." + method.getName();
        CustomGameTestHelper customHelper = ExtendedTestFunction.getCustomHelper(method, owner);
        ExtendedTestFunction.validateTestMethod(method, gt, owner, customHelper, qualifiedName);
        UnaryOperator<class_4516> helperProcessor = ExtendedTestFunction.getHelperProcessor(customHelper);
        String structure = ExtendedTestFunction.getStructure(gt, owner);
        class_2470 rotation = class_4525.method_29408((int)gt.method_35934());
        String fullName = owner.getName() + "." + method.getName();
        String simpleName = owner.getSimpleName() + "." + method.getName();
        return new ExtendedTestFunction(fullName, simpleName, helperProcessor, gt.method_35933(), structure, structure, rotation, gt.method_35932(), gt.method_35937(), gt.method_35935(), gt.method_35939(), gt.method_35938(), ExtendedTestFunction.asConsumer(method));
    }

    private static void validateTestMethod(Method method, class_6302 gt, Class<?> owner, CustomGameTestHelper customHelper, String qualifiedName) {
        Class<class_4516> helperClass;
        if (gt.method_35936().isEmpty()) {
            throw new IllegalArgumentException(qualifiedName + " must provide a template structure");
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new IllegalArgumentException(qualifiedName + " must be public and static");
        }
        if (!Modifier.isPublic(owner.getModifiers())) {
            throw new IllegalStateException(owner.getName() + " must be public");
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException(qualifiedName + " must return void");
        }
        Class clazz = helperClass = customHelper != null ? customHelper.value() : class_4516.class;
        if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != helperClass) {
            throw new IllegalArgumentException(qualifiedName + " must take 1 parameter of type " + helperClass.getSimpleName());
        }
    }

    private static String getStructure(class_6302 gt, Class<?> owner) {
        GameTestGroup group = owner.getAnnotation(GameTestGroup.class);
        String structure = gt.method_35936();
        if (group == null || structure.contains(":")) {
            return structure;
        }
        String groupDir = group.path();
        String path = groupDir.isEmpty() ? structure : groupDir + "/" + structure;
        return group.namespace() + ":gametest/" + path;
    }

    private static CustomGameTestHelper getCustomHelper(Method method, Class<?> owner) {
        CustomGameTestHelper methodCustom = method.getAnnotation(CustomGameTestHelper.class);
        return methodCustom != null ? methodCustom : owner.getAnnotation(CustomGameTestHelper.class);
    }

    private static UnaryOperator<class_4516> getHelperProcessor(CustomGameTestHelper custom) {
        if (custom == null) {
            return helper -> helper;
        }
        Class<? extends class_4516> klass = custom.value();
        try {
            Constructor<? extends class_4516> constructor = klass.getConstructor(class_4517.class);
            constructor.setAccessible(true);
            return helper -> {
                try {
                    class_4516 newHelper = (class_4516)constructor.newInstance(helper.field_20558);
                    newHelper.field_33146 = helper.field_33146;
                    return newHelper;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Consumer<class_4516> asConsumer(Method method) {
        return helper -> {
            try {
                method.invoke(null, helper);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void method_22297(@NotNull class_4516 helper) {
        StructureBlockEntityExtensions be = (StructureBlockEntityExtensions)helper.method_36014(class_2338.field_10980);
        be.setQualifiedTestName(this.fullyQualifiedName);
        super.method_22297((class_4516)this.helperProcessor.apply(helper));
    }
}

