/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.gametest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.github.fabricators_of_create.porting_lib.gametest.infrastructure.ExtendedTestFunction;
import io.github.fabricators_of_create.porting_lib.gametest.quickexport.AreaSelectorItem;
import io.github.fabricators_of_create.porting_lib.gametest.quickexport.QuickExportCommand;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4529;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortingLibGameTest
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Porting Lib GameTest");
    public static final boolean AREA_SELECTOR_ENABLED = PortingLibGameTest.checkEnabled();
    public static final class_1792 AREA_SELECTOR = AREA_SELECTOR_ENABLED ? new AreaSelectorItem((class_1792.class_1793)new FabricItemSettings()) : null;

    public void onInitialize() {
        if (AREA_SELECTOR_ENABLED) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("porting_lib", "area_selector"), (Object)AREA_SELECTOR);
            QuickExportCommand.register();
        } else {
            LOGGER.info("Porting Lib GameTest: Area Selector and quickexport disabled.");
        }
    }

    public static Collection<class_4529> getTestsFrom(Class<?> ... classes) {
        return Stream.of(classes).map(Class::getDeclaredMethods).flatMap(Stream::of).map(ExtendedTestFunction::of).filter(Objects::nonNull).sorted(Comparator.comparing(class_4529::method_22296)).toList();
    }

    private static boolean checkEnabled() {
        Path config = FabricLoader.getInstance().getConfigDir().resolve("porting_lib").resolve("gametest.json");
        if (!Files.exists(config, new LinkOption[0])) {
            return true;
        }
        try {
            JsonPrimitive disabled;
            JsonElement element = JsonParser.parseString((String)Files.readString(config));
            if (!(element instanceof JsonObject)) {
                throw new JsonParseException("Config is not a JSON object");
            }
            JsonObject json = (JsonObject)element;
            JsonElement disableElement = json.get("disable_area_selector");
            if (disableElement == null) {
                return true;
            }
            if (!(disableElement instanceof JsonPrimitive) || !(disabled = (JsonPrimitive)disableElement).isBoolean()) {
                throw new JsonParseException("Element 'disable_area_selector' must be a boolean");
            }
            return !disabled.getAsBoolean();
        }
        catch (JsonParseException | IOException e) {
            throw new RuntimeException("Porting Lib GameTest: Failed to read config", e);
        }
    }
}

