/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.static_utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.barribob.maelstrom.general.math.ReferencedAxisRotator;
import net.barribob.maelstrom.static_utilities.MathUtils;
import net.barribob.maelstrom.static_utilities.VecUtils;
import net.barribob.maelstrom.static_utilities.VecUtilsKt;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bP\u0010QJ\u001d\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ9\u0010\u0012\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J+\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u00a2\u0006\u0004\b#\u0010$J#\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\t2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%\u00a2\u0006\u0004\b(\u0010)J%\u0010-\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0002\u00a2\u0006\u0004\b-\u0010.J?\u00102\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001001\u00a2\u0006\u0004\b2\u00103J%\u00106\u001a\u00020\"2\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b6\u00107J-\u0010;\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b\u00a2\u0006\u0004\b;\u0010<J-\u0010@\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001b0\t2\b\b\u0002\u0010?\u001a\u00020\"\u00a2\u0006\u0004\b@\u0010AJ\u001d\u0010D\u001a\u00020\u00022\u0006\u0010B\u001a\u00020\u00022\u0006\u0010C\u001a\u00020\u0002\u00a2\u0006\u0004\bD\u0010\u0006J1\u0010I\u001a\u00020\"2\u0006\u0010F\u001a\u00020E2\u0006\u0010G\u001a\u00020\u00022\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\"0\u000f\u00a2\u0006\u0004\bI\u0010JJ%\u0010N\u001a\u00020\"2\u0006\u0010K\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u00022\u0006\u0010M\u001a\u00020\u0007\u00a2\u0006\u0004\bN\u0010O\u00a8\u0006R"}, d2={"Lnet/barribob/maelstrom/static_utilities/MathUtils;", "", "Lnet/minecraft/class_243;", "direction", "offset", "axisOffset", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Lnet/minecraft/class_243;", "", "radius", "", "buildBlockCircle", "(D)Ljava/util/List;", "", "points", "axis", "Lkotlin/Function1;", "", "callback", "circleCallback", "(DILnet/minecraft/class_243;Lkotlin/jvm/functions/Function1;)V", "", "circlePoints", "(DILnet/minecraft/class_243;)Ljava/util/Collection;", "firstNumber", "lastNumber", "consecutiveSum", "(II)I", "", "directionToPitch", "(Lnet/minecraft/class_243;)F", "directionToYaw", "(Lnet/minecraft/class_243;)D", "direction1", "direction2", "", "facingSameDirection", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Z", "Lnet/minecraft/class_2338;", "startPos", "endPos", "getBlocksInLine", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;)Ljava/util/List;", "partialTicks", "vec1", "vec2", "lerpVec", "(FLnet/minecraft/class_243;Lnet/minecraft/class_243;)Lnet/minecraft/class_243;", "start", "end", "Lkotlin/Function2;", "lineCallback", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;ILkotlin/jvm/functions/Function2;)V", "center", "pos", "movingTowards", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Z", "time", "ratio", "maxAge", "ratioLerp", "(FFFF)F", "n", "steps", "floor", "roundedStep", "(FLjava/util/List;Z)F", "source", "target", "unNormedDirection", "Lnet/minecraft/class_238;", "box", "movement", "collision", "willBoxFit", "(Lnet/minecraft/class_238;Lnet/minecraft/class_243;Lkotlin/jvm/functions/Function1;)Z", "pos1", "pos2", "distance", "withinDistance", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;D)Z", "<init>", "()V", "maelstrom-library"})
public final class MathUtils {
    @NotNull
    public static final MathUtils INSTANCE = new MathUtils();

    private MathUtils() {
    }

    public final boolean withinDistance(@NotNull class_243 pos1, @NotNull class_243 pos2, double distance) {
        Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance cannot be negative");
        }
        return pos1.method_1025(pos2) < Math.pow(distance, 2.0);
    }

    public final boolean movingTowards(@NotNull class_243 center, @NotNull class_243 pos, @NotNull class_243 direction) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        class_243 directionTo = this.unNormedDirection(pos, center);
        return direction.method_1026(directionTo) > 0.0;
    }

    @NotNull
    public final class_243 unNormedDirection(@NotNull class_243 source, @NotNull class_243 target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        class_243 class_2432 = target.method_1020(source);
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"target.subtract(source)");
        return class_2432;
    }

    public final void lineCallback(@NotNull class_243 start, @NotNull class_243 end, int points, @NotNull Function2<? super class_243, ? super Integer, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        class_243 class_2432 = end.method_1020(start).method_1021(1.0 / (double)(points - 1));
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"end.subtract(start).mult\u2026 (points - 1).toDouble())");
        class_243 dir = class_2432;
        class_243 pos = start;
        int n = 0;
        while (n < points) {
            int i = n++;
            callback.invoke((Object)pos, (Object)i);
            class_243 class_2433 = pos.method_1019(dir);
            Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"pos.add(dir)");
            pos = class_2433;
        }
    }

    public final void circleCallback(double radius, int points, @NotNull class_243 axis, @NotNull Function1<? super class_243, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        double degrees = Math.PI * 2 / (double)points;
        double axisYaw = this.directionToYaw(axis);
        ReferencedAxisRotator rotator = new ReferencedAxisRotator(VecUtils.INSTANCE.getYAxis(), axis);
        int n = 0;
        while (n < points) {
            int i = n++;
            double radians = (double)i * degrees;
            class_243 class_2432 = new class_243(Math.sin(radians), 0.0, Math.cos(radians)).method_1021(radius);
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"Vec3d(sin(radians), 0.0,\u2026        .multiply(radius)");
            class_243 offset = VecUtilsKt.rotateVector(class_2432, VecUtils.INSTANCE.getYAxis(), -axisYaw);
            class_243 rotated = rotator.rotate(offset);
            callback.invoke((Object)rotated);
        }
    }

    @NotNull
    public final Collection<class_243> circlePoints(double radius, int points, @NotNull class_243 axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        List vectors = new ArrayList();
        this.circleCallback(radius, points, axis, (Function1<? super class_243, Unit>)((Function1)new Function1<class_243, Unit>((Object)vectors){

            public final void invoke(@NotNull class_243 p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                MathUtils.access$circlePoints$add((List)circlePoints.1.access$getReceiver$p(this), p0);
            }

            public static final /* synthetic */ Object access$getReceiver$p(circlePoints.1 $this) {
                return $this.receiver;
            }
        }));
        return vectors;
    }

    public final boolean willBoxFit(@NotNull class_238 box, @NotNull class_243 movement, @NotNull Function1<? super class_238, Boolean> collision) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter((Object)movement, (String)"movement");
        Intrinsics.checkNotNullParameter(collision, (String)"collision");
        Ref.BooleanRef collided = new Ref.BooleanRef();
        int points = (int)Math.ceil(movement.method_1033() / box.method_995());
        class_243 class_2432 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
        this.lineCallback(class_2432, movement, points, (Function2<? super class_243, ? super Integer, Unit>)((Function2)new Function2<class_243, Integer, Unit>(collision, box, collided){
            final /* synthetic */ Function1<class_238, Boolean> $collision;
            final /* synthetic */ class_238 $box;
            final /* synthetic */ Ref.BooleanRef $collided;
            {
                this.$collision = $collision;
                this.$box = $box;
                this.$collided = $collided;
                super(2);
            }

            public final void invoke(@NotNull class_243 vec3d, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)vec3d, (String)"vec3d");
                class_238 class_2382 = this.$box.method_997(vec3d);
                Intrinsics.checkNotNullExpressionValue((Object)class_2382, (String)"box.offset(vec3d)");
                if (((Boolean)this.$collision.invoke((Object)class_2382)).booleanValue()) {
                    this.$collided.element = true;
                }
            }
        }));
        return !collided.element;
    }

    public final float directionToPitch(@NotNull class_243 direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        double x = direction.field_1352;
        double z = direction.field_1350;
        double y = direction.field_1351;
        double h = Math.sqrt(x * x + z * z);
        return (float)Math.toDegrees(-class_3532.method_15349((double)y, (double)h));
    }

    public final double directionToYaw(@NotNull class_243 direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        double x = direction.field_1352;
        double z = direction.field_1350;
        return Math.toDegrees(class_3532.method_15349((double)z, (double)x));
    }

    @NotNull
    public final class_243 lerpVec(float partialTicks, @NotNull class_243 vec1, @NotNull class_243 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec1, (String)"vec1");
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"vec2");
        double pt = partialTicks;
        double x = class_3532.method_16436((double)pt, (double)vec1.field_1352, (double)vec2.field_1352);
        double y = class_3532.method_16436((double)pt, (double)vec1.field_1351, (double)vec2.field_1351);
        double z = class_3532.method_16436((double)pt, (double)vec1.field_1350, (double)vec2.field_1350);
        return new class_243(x, y, z);
    }

    @NotNull
    public final class_243 axisOffset(@NotNull class_243 direction, @NotNull class_243 offset) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        class_243 class_2432 = direction.method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"direction.normalize()");
        class_243 forward = class_2432;
        class_243 class_2433 = forward.method_1036(VecUtils.INSTANCE.getYAxis()).method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"forward.crossProduct(VecUtils.yAxis).normalize()");
        class_243 side = class_2433;
        class_243 class_2434 = side.method_1036(forward).method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"side.crossProduct(forward).normalize()");
        class_243 up = class_2434;
        class_2434 = forward.method_1021(offset.field_1352).method_1019(side.method_1021(offset.field_1350)).method_1019(up.method_1021(offset.field_1351));
        Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"forward.multiply(offset.\u2026dd(up.multiply(offset.y))");
        return class_2434;
    }

    public final boolean facingSameDirection(@NotNull class_243 direction1, @NotNull class_243 direction2) {
        Intrinsics.checkNotNullParameter((Object)direction1, (String)"direction1");
        Intrinsics.checkNotNullParameter((Object)direction2, (String)"direction2");
        return direction1.method_1026(direction2) > 0.0;
    }

    public final int consecutiveSum(int firstNumber, int lastNumber) {
        return (int)((float)(lastNumber - firstNumber + 1) * ((float)(firstNumber + lastNumber) * 0.5f));
    }

    public final float roundedStep(float n, @NotNull List<Float> steps, boolean floor) {
        float f;
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        if (floor) {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = CollectionsKt.sortedDescending((Iterable)steps);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    float it = ((Number)element$iv).floatValue();
                    boolean bl = false;
                    if (!(it <= n)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Float f2 = v0;
            f = f2 == null ? ((Number)CollectionsKt.first(steps)).floatValue() : f2.floatValue();
        } else {
            Object v3;
            block5: {
                Iterable $this$firstOrNull$iv = CollectionsKt.sorted((Iterable)steps);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    float it = ((Number)element$iv).floatValue();
                    boolean bl = false;
                    if (!(it > n)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            Float f3 = v3;
            f = f3 == null ? ((Number)CollectionsKt.last(steps)).floatValue() : f3.floatValue();
        }
        return f;
    }

    public static /* synthetic */ float roundedStep$default(MathUtils mathUtils, float f, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return mathUtils.roundedStep(f, list, bl);
    }

    @NotNull
    public final List<class_243> buildBlockCircle(double radius) {
        int intRadius = (int)radius;
        double radiusSq = radius * radius;
        List points = new ArrayList();
        int n = -intRadius;
        if (n <= intRadius) {
            int x;
            do {
                int z;
                x = n++;
                int n2 = -intRadius;
                if (n2 > intRadius) continue;
                do {
                    class_243 pos;
                    if (!((pos = new class_243((double)x, 0.0, (double)(z = n2++))).method_1027() <= radiusSq)) continue;
                    points.add(pos);
                } while (z != intRadius);
            } while (x != intRadius);
        }
        return points;
    }

    @NotNull
    public final List<class_2338> getBlocksInLine(@NotNull class_2338 startPos, @NotNull class_2338 endPos) {
        int zs;
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)endPos, (String)"endPos");
        int x1 = startPos.method_10263();
        int y1 = startPos.method_10264();
        int z1 = startPos.method_10260();
        int x2 = endPos.method_10263();
        int y2 = endPos.method_10264();
        int z2 = endPos.method_10260();
        Object[] objectArray = new class_2338[]{startPos};
        List points = CollectionsKt.mutableListOf((Object[])objectArray);
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x2 > x1 ? 1 : -1;
        int ys = y2 > y1 ? 1 : -1;
        int n = zs = z2 > z1 ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                points.add(new class_2338(x1, y1, z1));
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                points.add(new class_2338(x1, y1, z1));
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                points.add(new class_2338(x1, y1, z1));
            }
        }
        return points;
    }

    public final float ratioLerp(float time, float ratio, float maxAge, float partialTicks) {
        boolean bl;
        boolean bl2 = bl = ratio <= 1.0f;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = ratio >= 0.0f;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = maxAge > 0.0f;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        float currentTime = class_3532.method_15363((float)((time + partialTicks) / maxAge), (float)0.0f, (float)1.0f);
        return Math.max(0.0f, currentTime - ratio) / (1.0f - ratio);
    }

    public static final /* synthetic */ void access$circlePoints$add(List $receiver, class_243 p0) {
        $receiver.add(p0);
    }
}

