/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general.event;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.general.event.IEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007J\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u00020\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lnet/barribob/maelstrom/general/event/EventSeries;", "Lnet/barribob/maelstrom/general/event/IEvent;", "", "doEvent", "()V", "", "shouldDoEvent", "()Z", "shouldRemoveEvent", "", "tickSize", "()I", "currentEvent", "Lnet/barribob/maelstrom/general/event/IEvent;", "getCurrentEvent", "()Lnet/barribob/maelstrom/general/event/IEvent;", "setCurrentEvent", "(Lnet/barribob/maelstrom/general/event/IEvent;)V", "", "iterator", "Ljava/util/Iterator;", "getIterator", "()Ljava/util/Iterator;", "", "events", "<init>", "([Lnet/barribob/maelstrom/general/event/IEvent;)V", "maelstrom-library"})
public final class EventSeries
implements IEvent {
    @NotNull
    private final Iterator<IEvent> iterator;
    @NotNull
    private IEvent currentEvent;

    public EventSeries(IEvent ... events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.iterator = ArrayIteratorKt.iterator((Object[])events);
        if (!this.iterator.hasNext()) {
            throw new IllegalArgumentException("Must have at least one event");
        }
        this.currentEvent = this.iterator.next();
    }

    @NotNull
    public final Iterator<IEvent> getIterator() {
        return this.iterator;
    }

    @NotNull
    public final IEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public final void setCurrentEvent(@NotNull IEvent iEvent) {
        Intrinsics.checkNotNullParameter((Object)iEvent, (String)"<set-?>");
        this.currentEvent = iEvent;
    }

    @Override
    public boolean shouldDoEvent() {
        return this.currentEvent.shouldDoEvent();
    }

    @Override
    public void doEvent() {
        this.currentEvent.doEvent();
    }

    @Override
    public boolean shouldRemoveEvent() {
        while (this.currentEvent.shouldRemoveEvent()) {
            if (this.iterator.hasNext()) {
                this.currentEvent = this.iterator.next();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public int tickSize() {
        return this.currentEvent.tickSize();
    }
}

