/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.dsl;

import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolders;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.gson.stream.JsonReader;
import io.gitlab.jfronny.gson.stream.JsonToken;
import io.gitlab.jfronny.gson.stream.JsonWriter;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.Entry;
import io.gitlab.jfronny.libjf.config.api.v1.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v1.type.Type;
import io.gitlab.jfronny.libjf.config.impl.entrypoint.JfConfigSafe;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class DslEntryInfo<T>
implements EntryInfo<T> {
    private final String name;
    private final T defaultValue;
    private final ThrowingSupplier<T, IllegalAccessException> get;
    private final ThrowingConsumer<T, IllegalAccessException> set;
    private final Type type;
    private final int width;
    private final double minValue;
    private final double maxValue;

    public DslEntryInfo(String name, T defaultValue, ThrowingSupplier<T, IllegalAccessException> get, ThrowingConsumer<T, IllegalAccessException> set, Type type, int width, double minValue, double maxValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.get = get;
        this.set = set;
        this.type = type;
        this.width = width;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public DslEntryInfo(String name, T def, ThrowingSupplier<T, IllegalAccessException> get, ThrowingConsumer<T, IllegalAccessException> set, Type type) {
        this(name, def, get, set, type, 100, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static DslEntryInfo<Object> ofField(Field field) {
        Entry entry = field.getAnnotation(Entry.class);
        Object defaultValue = null;
        try {
            defaultValue = field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new DslEntryInfo<Object>(field.getName(), defaultValue, () -> field.get(null), v -> field.set(null, v), Type.ofClass(field.getGenericType()), entry == null ? 100 : entry.width(), entry == null ? Double.NEGATIVE_INFINITY : entry.min(), entry == null ? Double.POSITIVE_INFINITY : entry.max());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T getValue() throws IllegalAccessException {
        return (T)this.get.get();
    }

    @Override
    public void setValue(T value) throws IllegalAccessException {
        this.set.accept(value);
    }

    @Override
    public Type getValueType() {
        return this.type;
    }

    @Override
    public void fix() {
        Object value;
        try {
            value = this.getValue();
        }
        catch (IllegalAccessException e) {
            LibJf.LOGGER.error("Could not read value", (Throwable)e);
            return;
        }
        T valueOriginal = value;
        if (value instanceof Integer) {
            Integer v = (Integer)value;
            if ((double)v.intValue() < this.minValue) {
                value = (int)this.minValue;
            }
            if ((double)v.intValue() > this.maxValue) {
                value = (int)this.maxValue;
            }
        } else if (value instanceof Float) {
            Float v = (Float)value;
            if ((double)v.floatValue() < this.minValue) {
                value = Float.valueOf((float)this.minValue);
            }
            if ((double)v.floatValue() > this.maxValue) {
                value = Float.valueOf((float)this.maxValue);
            }
        } else if (value instanceof Double) {
            Double v = (Double)value;
            if (v < this.minValue) {
                value = this.minValue;
            }
            if (v > this.maxValue) {
                value = this.maxValue;
            }
        }
        if (valueOriginal != value) {
            try {
                this.setUnchecked(value);
            }
            catch (IllegalAccessException e) {
                LibJf.LOGGER.error("Could not write value", (Throwable)e);
            }
        }
    }

    @Override
    public void loadFromJson(JsonReader reader) throws IOException, IllegalAccessException {
        JsonToken next = reader.peek();
        if (this.type.isBool()) {
            if (next == JsonToken.BOOLEAN) {
                this.setUnchecked(reader.nextBoolean());
            } else {
                LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected boolean but got " + next);
            }
        } else if (this.type.isString()) {
            if (next == JsonToken.STRING || next == JsonToken.NUMBER) {
                this.setUnchecked(reader.nextString());
            } else if (next == JsonToken.BOOLEAN) {
                this.setUnchecked(Boolean.toString(reader.nextBoolean()));
            } else if (next == JsonToken.NULL) {
                this.setUnchecked(null);
            } else {
                LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected string but got " + next);
            }
        } else if (this.type.isInt()) {
            if (next == JsonToken.NUMBER) {
                this.setUnchecked(reader.nextInt());
            } else {
                LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + next);
            }
        } else if (this.type.isLong()) {
            if (next == JsonToken.NUMBER) {
                this.setUnchecked(reader.nextLong());
            } else {
                LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + next);
            }
        } else if (this.type.isDouble()) {
            if (next == JsonToken.NUMBER) {
                this.setUnchecked(reader.nextDouble());
            } else {
                LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + next);
            }
        } else if (this.type.isFloat()) {
            if (next == JsonToken.NUMBER) {
                this.setUnchecked(Float.valueOf((float)reader.nextDouble()));
            } else {
                LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + next);
            }
        } else if (this.type.isEnum()) {
            Type.TEnum e = (Type.TEnum)this.type;
            if (next == JsonToken.STRING) {
                this.setUnchecked(e.optionForString(reader.nextString()));
            } else {
                LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected string but got " + next);
            }
        } else {
            this.setValue(GsonHolders.CONFIG.getGson().fromJson(reader, this.type.asClass()));
        }
    }

    private void setUnchecked(Object object) throws IllegalAccessException {
        if (object == null) {
            return;
        }
        this.setValue(object);
    }

    @Override
    public void writeTo(JsonWriter writer, String translationPrefix) throws IOException, IllegalAccessException {
        T value = this.getValue();
        String val = (String)JfConfigSafe.TRANSLATION_SUPPLIER.apply(translationPrefix + this.getName() + ".tooltip");
        if (val != null) {
            writer.comment(val);
        }
        if (this.type.isEnum()) {
            writer.comment("Valid: [" + Arrays.stream(((Type.TEnum)this.type).options()).map(Objects::toString).collect(Collectors.joining(", ")) + "]");
        }
        writer.name(this.name);
        GsonHolders.CONFIG.getGson().toJson(value, (java.lang.reflect.Type)((Object)Objects.requireNonNullElse(this.type.asClass(), String.class)), writer);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }
}

