/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.dsl;

import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolders;
import io.gitlab.jfronny.gson.JsonParseException;
import io.gitlab.jfronny.gson.stream.JsonReader;
import io.gitlab.jfronny.gson.stream.JsonToken;
import io.gitlab.jfronny.gson.stream.JsonWriter;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v1.EntryInfo;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslConfigCategory;
import io.gitlab.jfronny.libjf.config.impl.entrypoint.JfConfigSafe;
import io.gitlab.jfronny.libjf.config.impl.watch.JfConfigWatchService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;

public class DefaultConfigIO {
    public static Consumer<ConfigInstance> loader(String id) {
        return c -> c.getFilePath().ifPresent(path -> {
            if (Files.exists(path, new LinkOption[0])) {
                try (BufferedReader br = Files.newBufferedReader(path);
                     JsonReader jr = GsonHolders.CONFIG.getGson().newJsonReader((Reader)br);){
                    DefaultConfigIO.runActions(id, DefaultConfigIO.createActions(c), jr);
                }
                catch (Exception e) {
                    LibJf.LOGGER.error("Could not read config for " + id, (Throwable)e);
                }
            }
            c.write();
        });
    }

    private static void runActions(String id, Map<String, Action> actions, JsonReader reader) {
        try {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                LibJf.LOGGER.error("Invalid config: Not a JSON object for " + id);
                return;
            }
            HashSet<String> appeared = new HashSet<String>();
            reader.beginObject();
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name2 = reader.nextName();
                if (!actions.containsKey(name2)) {
                    LibJf.LOGGER.warn("Unrecognized key in config for " + id + ": " + name2);
                    continue;
                }
                if (!appeared.add(name2)) {
                    LibJf.LOGGER.warn("Duplicate key in config for " + id + ": " + name2);
                    continue;
                }
                actions.get((Object)name2).task.accept(reader);
            }
            reader.endObject();
            actions.forEach((name, action) -> {
                if (action.required && !appeared.contains(name)) {
                    LibJf.LOGGER.error("Missing entry in config for " + id + ": " + name);
                }
            });
        }
        catch (IOException e) {
            throw new JsonParseException("Could not read config", (Throwable)e);
        }
    }

    private static Map<String, Action> createActions(ConfigCategory category) {
        HashMap actions = new HashMap();
        category.getEntries().forEach(entry -> actions.putIfAbsent(entry.getName(), new Action(reader -> {
            try {
                entry.loadFromJson((JsonReader)reader);
            }
            catch (IOException | IllegalAccessException e) {
                LibJf.LOGGER.error("Could not set config entry value of " + entry.getName(), (Throwable)e);
            }
        })));
        category.getCategories().forEach((id, cat) -> {
            String innerId = category.getId() + "." + id;
            Map<String, Action> innerActions = DefaultConfigIO.createActions(cat);
            actions.putIfAbsent(id, new Action(reader -> DefaultConfigIO.runActions(innerId, innerActions, reader)));
        });
        if (category instanceof DslConfigCategory) {
            DslConfigCategory cat2 = (DslConfigCategory)category;
            cat2.migrations.forEach((id, migration) -> actions.putIfAbsent(id, new Action((Consumer<JsonReader>)migration, false)));
        }
        return Map.copyOf(actions);
    }

    public static Consumer<ConfigInstance> writer(String id) {
        return c -> c.getFilePath().ifPresent(path -> JfConfigWatchService.lock(path, () -> {
            try (BufferedWriter bw = Files.newBufferedWriter(path, new OpenOption[0]);
                 JsonWriter jw = GsonHolders.CONFIG.getGson().newJsonWriter((Writer)bw);){
                DefaultConfigIO.writeTo(jw, c);
            }
            catch (Exception e) {
                LibJf.LOGGER.error("Could not write config for " + id, (Throwable)e);
            }
        }));
    }

    private static void writeTo(JsonWriter writer, ConfigCategory category) throws IOException {
        category.fix();
        writer.beginObject();
        for (EntryInfo<?> entryInfo : category.getEntries()) {
            try {
                entryInfo.writeTo(writer, category.getTranslationPrefix());
            }
            catch (IllegalAccessException e) {
                LibJf.LOGGER.error("Could not write entry", (Throwable)e);
            }
        }
        for (Map.Entry entry : category.getCategories().entrySet()) {
            String val = (String)JfConfigSafe.TRANSLATION_SUPPLIER.apply(category.getTranslationPrefix() + (String)entry.getKey() + ".title");
            if (val != null) {
                writer.comment(val);
            }
            writer.name((String)entry.getKey());
            DefaultConfigIO.writeTo(writer, (ConfigCategory)entry.getValue());
        }
        writer.endObject();
    }

    record Action(Consumer<JsonReader> task, boolean required) {
        public Action(Consumer<JsonReader> task) {
            this(task, true);
        }
    }
}

