/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.api.v1;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v1.EntryInfo;
import java.util.List;
import java.util.Map;

public interface ConfigCategory {
    public String getId();

    public String getCategoryPath();

    default public String getTranslationPrefix() {
        return this.getId() + ".jfconfig." + this.getCategoryPath();
    }

    public List<EntryInfo<?>> getEntries();

    public Map<String, Runnable> getPresets();

    public List<ConfigInstance> getReferencedConfigs();

    public Map<String, ConfigCategory> getCategories();

    public ConfigInstance getRoot();

    default public void fix() {
        for (EntryInfo<?> entry : this.getEntries()) {
            entry.fix();
        }
    }

    default public void reset() {
        for (EntryInfo<?> entry : this.getEntries()) {
            try {
                entry.reset();
            }
            catch (IllegalAccessException e) {
                LibJf.LOGGER.error("Could not reload default values", (Throwable)e);
            }
        }
    }
}

