/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.util.bluemapcore;

import io.gitlab.jfronny.libjf.web.impl.util.bluemapcore.HttpConnection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequest {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^(\\w+) (\\S+) (.+)$");
    private final String method;
    private final String adress;
    private final String version;
    private final Map<String, Set<String>> header;
    private final Map<String, Set<String>> headerLC;
    private byte[] data;
    private String path = null;
    private Map<String, String> getParams = null;
    private String getParamString = null;

    public HttpRequest(String method, String adress, String version, Map<String, Set<String>> header) {
        this.method = method;
        this.adress = adress;
        this.version = version;
        this.header = header;
        this.headerLC = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> e : header.entrySet()) {
            HashSet<String> values = new HashSet<String>();
            for (String v : e.getValue()) {
                values.add(v.toLowerCase());
            }
            this.headerLC.put(e.getKey().toLowerCase(), values);
        }
        this.data = new byte[0];
    }

    public String getMethod() {
        return this.method;
    }

    public String getAdress() {
        return this.adress;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Set<String>> getHeader() {
        return this.header;
    }

    public Map<String, Set<String>> getLowercaseHeader() {
        return this.headerLC;
    }

    public Set<String> getHeader(String key) {
        Set<String> headerValues = this.header.get(key);
        if (headerValues == null) {
            return Collections.emptySet();
        }
        return headerValues;
    }

    public Set<String> getLowercaseHeader(String key) {
        Set<String> headerValues = this.headerLC.get(key.toLowerCase());
        if (headerValues == null) {
            return Collections.emptySet();
        }
        return headerValues;
    }

    public String getPath() {
        if (this.path == null) {
            this.parseAdress();
        }
        return this.path;
    }

    public Map<String, String> getGETParams() {
        if (this.getParams == null) {
            this.parseAdress();
        }
        return Collections.unmodifiableMap(this.getParams);
    }

    public String getGETParamString() {
        if (this.getParamString == null) {
            this.parseAdress();
        }
        return this.getParamString;
    }

    private void parseAdress() {
        String adress = this.adress;
        if (adress.isEmpty()) {
            adress = "/";
        }
        String[] adressParts = adress.split("\\?", 2);
        String path = adressParts[0];
        this.getParamString = adressParts.length > 1 ? adressParts[1] : "";
        HashMap<String, String> getParams = new HashMap<String, String>();
        for (String getParam : this.getParamString.split("&")) {
            if (getParam.isEmpty()) continue;
            String[] kv = getParam.split("=", 2);
            String key = kv[0];
            String value = kv.length > 1 ? kv[1] : "";
            getParams.put(key, value);
        }
        this.path = path;
        this.getParams = getParams;
    }

    public InputStream getData() {
        return new ByteArrayInputStream(this.data);
    }

    public static HttpRequest read(InputStream in) throws IOException {
        String headerLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        ArrayList<String> header = new ArrayList<String>(20);
        while (header.size() < 1000 && !(headerLine = HttpRequest.readLine(reader)).isEmpty()) {
            header.add(headerLine);
        }
        if (header.isEmpty()) {
            throw new HttpConnection.InvalidRequestException();
        }
        Matcher m = REQUEST_PATTERN.matcher((CharSequence)header.remove(0));
        if (!m.find()) {
            throw new HttpConnection.InvalidRequestException();
        }
        String method = m.group(1);
        if (method == null) {
            throw new HttpConnection.InvalidRequestException();
        }
        String adress = m.group(2);
        if (adress == null) {
            throw new HttpConnection.InvalidRequestException();
        }
        String version = m.group(3);
        if (version == null) {
            throw new HttpConnection.InvalidRequestException();
        }
        HashMap<String, Set<String>> headerMap = new HashMap<String, Set<String>>();
        for (String line : header) {
            String[] kv;
            if (line.trim().isEmpty() || (kv = line.split(":", 2)).length < 2) continue;
            HashSet<String> values = new HashSet<String>();
            if (kv[0].trim().equalsIgnoreCase("If-Modified-Since")) {
                values.add(kv[1].trim());
            } else {
                for (String v : kv[1].split(",")) {
                    values.add(v.trim());
                }
            }
            headerMap.put(kv[0].trim(), values);
        }
        HttpRequest request = new HttpRequest(method, adress, version, headerMap);
        if (request.getLowercaseHeader("Transfer-Encoding").contains("chunked")) {
            try {
                String hexSize;
                int chunkSize;
                ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                while (dataStream.size() < 1000000 && (chunkSize = Integer.parseInt(hexSize = reader.readLine(), 16)) > 0) {
                    byte[] data = new byte[chunkSize];
                    in.read(data);
                    dataStream.write(data);
                }
                if (dataStream.size() >= 1000000) {
                    throw new HttpConnection.InvalidRequestException();
                }
                request.data = dataStream.toByteArray();
                return request;
            }
            catch (NumberFormatException ex) {
                return request;
            }
        }
        Set<String> clSet = request.getLowercaseHeader("Content-Length");
        if (clSet.isEmpty()) {
            return request;
        }
        try {
            int cl = Integer.parseInt(clSet.iterator().next());
            byte[] data = new byte[cl];
            in.read(data);
            request.data = data;
            return request;
        }
        catch (NumberFormatException ex) {
            return request;
        }
    }

    private static String readLine(BufferedReader in) throws IOException {
        String line = in.readLine();
        if (line == null) {
            throw new HttpConnection.ConnectionClosedException();
        }
        return line;
    }
}

