/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.gitlab.jfronny.libjf.Flags;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.coprocess.CoProcess;
import io.gitlab.jfronny.libjf.web.api.WebServer;
import io.gitlab.jfronny.libjf.web.impl.JfWebConfig;
import io.gitlab.jfronny.libjf.web.impl.JfWebServer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class JfWeb
implements CoProcess,
ModInitializer {
    public static final WebServer SERVER;

    public void start() {
        if (this.isEnabled()) {
            SERVER.restart();
        }
    }

    public void stop() {
        if (this.isEnabled()) {
            SERVER.stop();
        }
    }

    public void onInitialize() {
        if (this.isEnabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"libjf").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"web").requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(context -> {
                if (SERVER.isActive()) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"LibWeb is active. Use libweb restart to reload"), false);
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"LibWeb is not active. Use libweb restart to reload"), false);
                }
                return 1;
            })).then(class_2170.method_9247((String)"restart").executes(context -> {
                try {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Restarting LibWeb"), true);
                    SERVER.restart();
                }
                catch (Exception e) {
                    LibJf.LOGGER.error("Failed to run restart command", (Throwable)e);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
                }
                return 1;
            })))));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(SERVER::stop));
    }

    private boolean isEnabled() {
        boolean enable = JfWebConfig.enableFileHost;
        for (Flags.BooleanFlag web : Flags.getBoolFlags((String)"web")) {
            enable |= web.value();
        }
        return enable;
    }

    static {
        JfWebConfig.ensureValidPort();
        SERVER = new JfWebServer(JfWebConfig.port, JfWebConfig.maxConnections);
    }
}

