/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.dimension;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.BaseMapCodec;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record FailSoftMapCodec<K, V>(Codec<K> keyCodec, Codec<V> elementCodec) implements BaseMapCodec<K, V>,
Codec<Map<K, V>>
{
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FailSoftMapCodec");

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> this.decode(ops, (MapLike)map)).map(r -> Pair.of((Object)r, (Object)input));
    }

    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        return this.encode(input, ops, ops.mapBuilder()).build(prefix);
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        input.entries().forEach(pair -> {
            try {
                DataResult k = this.keyCodec().parse(ops, pair.getFirst());
                DataResult v = this.elementCodec().parse(ops, pair.getSecond());
                k.get().ifRight(kPartialResult -> LOGGER.error("Failed to decode key {} from {}  {}", new Object[]{k, pair, kPartialResult}));
                v.get().ifRight(vPartialResult -> LOGGER.error("Failed to decode value {} from {}  {}", new Object[]{v, pair, vPartialResult}));
                if (k.get().left().isPresent() && v.get().left().isPresent()) {
                    builder.put(k.get().left().get(), v.get().left().get());
                }
            }
            catch (Throwable e) {
                LOGGER.error("Decoding {}", pair, (Object)e);
            }
        });
        ImmutableMap elements = builder.build();
        return DataResult.success((Object)elements);
    }

    @Override
    public String toString() {
        return "FailSoftMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.elementCodec) + "]";
    }
}

