/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.mixin.other;

import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerIdList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2361;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2361.class})
public abstract class IdListMixin<T>
implements PolymerIdList<T> {
    @Shadow
    @Mutable
    private List<T> field_11098;
    @Shadow
    private int field_11099;
    @Shadow
    @Final
    private Object2IntMap<Object> field_11100;
    @Unique
    private int polymer$nonPolymerBitCount;
    @Unique
    private int polymer$vanillaBitCount;
    @Unique
    private int polymer$vanillaEntryCount;
    @Unique
    private final List<T> polymer$lazyList = new ArrayList<T>();
    @Unique
    private final Set<T> polymer$states = new ObjectOpenCustomHashSet(class_156.method_655());
    @Unique
    private boolean polymer$locked = true;
    @Unique
    private int polymer$offset = Integer.MAX_VALUE;
    @Unique
    private boolean polymer$hasPolymer = false;
    @Unique
    private boolean polymer$initializeLazy = true;
    @Unique
    private boolean polymer$reorderLock = false;
    @Unique
    private Predicate<T> polymer$polymerEntryChecker;
    @Unique
    private Predicate<T> polymer$serverEntryChecker;
    @Unique
    private boolean polymer$isPolymerAware;
    @Unique
    private Function<T, String> polymer$nameCreator;

    @Shadow
    public abstract void method_10205(T var1);

    @Shadow
    public abstract int method_10204();

    @Inject(method={"add"}, at={@At(value="HEAD")}, cancellable=true)
    private void polymer$moveToEnd(T value, CallbackInfo ci) {
        if (this.polymer$isPolymerAware) {
            if (this.field_11100.containsKey(value)) {
                ci.cancel();
                return;
            }
            boolean isPolymerObj = this.polymer$polymerEntryChecker.test(value);
            if (isPolymerObj || this.polymer$serverEntryChecker.test(value)) {
                this.polymer$states.add(value);
            } else {
                ++this.polymer$vanillaEntryCount;
            }
            if (isPolymerObj) {
                if (this.polymer$locked) {
                    this.polymer$lazyList.add(value);
                    ci.cancel();
                    return;
                }
                this.polymer$hasPolymer = true;
                this.polymer$offset = Math.min(this.polymer$offset, this.field_11099);
            }
            if (this.polymer$hasPolymer && !isPolymerObj && this.polymer$offset <= this.field_11099) {
                if (this.polymer$reorderLock) {
                    PolymerImpl.LOGGER.warn("Someone registered object while IdList is locked! Related: " + this.polymer$nameCreator.apply(value));
                } else {
                    StackTraceElement[] trace;
                    if (PolymerImpl.LOG_BLOCKSTATE_REBUILDS && PolymerImplUtils.shouldLogStateRebuild(trace = Thread.currentThread().getStackTrace())) {
                        PolymerImpl.LOGGER.warn("Rebuilding IdList! Someone accessed it too early...");
                        StringBuilder builder = new StringBuilder();
                        int line = 0;
                        for (StackTraceElement stackTrace : trace) {
                            if (line > 0) {
                                builder.append("\t").append(stackTrace.toString()).append("\n");
                            }
                            if (line > 24) break;
                            ++line;
                        }
                        PolymerImpl.LOGGER.warn("Called by:\n" + builder);
                    }
                    ArrayList<T> copy = new ArrayList<T>(this.field_11098);
                    this.polymer$clear();
                    for (T entry : copy) {
                        if (entry == null) continue;
                        this.method_10205(entry);
                    }
                }
            }
            this.polymer$nonPolymerBitCount = class_3532.method_15342((int)(this.field_11098.size() - this.polymer$states.size()));
            this.polymer$vanillaEntryCount = class_3532.method_15342((int)this.polymer$vanillaEntryCount);
        }
    }

    @Override
    public Collection<T> polymer$getPolymerEntries() {
        return this.polymer$states;
    }

    @Inject(method={"get"}, at={@At(value="HEAD")})
    private void polymer$onGet(int index, CallbackInfoReturnable<@Nullable T> cir) {
        this.polymer$initLazy();
    }

    @Inject(method={"getRawId"}, at={@At(value="HEAD")})
    private void polymer$onGetId(T entry, CallbackInfoReturnable<Integer> cir) {
        this.polymer$initLazy();
    }

    @Inject(method={"size"}, at={@At(value="HEAD")})
    private void polymer$onSize(CallbackInfoReturnable<Integer> cir) {
        this.polymer$initLazy();
    }

    @Inject(method={"iterator"}, at={@At(value="HEAD")})
    private void polymer$onIterator(CallbackInfoReturnable<Iterator<T>> cir) {
        this.polymer$initLazy();
    }

    private void polymer$initLazy() {
        if (this.polymer$locked && this.polymer$initializeLazy) {
            if (StackWalker.getInstance().walk(PolymerImplUtils::shouldSkipStateInitialization).booleanValue()) {
                return;
            }
            this.polymer$offset = this.field_11099;
            this.polymer$locked = false;
            this.polymer$lazyList.forEach(this::method_10205);
            this.polymer$lazyList.clear();
            this.polymer$nonPolymerBitCount = class_3532.method_15342((int)(this.field_11098.size() - this.polymer$states.size()));
        }
    }

    @Override
    public int polymer$getNonPolymerBitCount() {
        return this.polymer$nonPolymerBitCount;
    }

    @Override
    public int polymer$getVanillaBitCount() {
        return this.polymer$vanillaBitCount;
    }

    @Override
    public void polymer$setChecker(Predicate<T> polymerChecker, Predicate<T> serverChecker, Function<T, String> namer) {
        this.polymer$polymerEntryChecker = polymerChecker;
        this.polymer$serverEntryChecker = serverChecker;
        this.polymer$isPolymerAware = polymerChecker != null;
        this.polymer$nameCreator = namer;
    }

    @Override
    public void polymer$setIgnoreCalls(boolean value) {
        this.polymer$initializeLazy = !value;
    }

    @Override
    public int polymer$getOffset() {
        return this.polymer$offset;
    }

    @Override
    public void polymer$setReorderLock(boolean value) {
        this.polymer$reorderLock = value;
    }

    @Override
    public boolean polymer$getReorderLock() {
        return this.polymer$reorderLock;
    }

    @Override
    public void polymer$clear() {
        this.field_11099 = 0;
        this.field_11100.clear();
        this.field_11098.clear();
        this.polymer$vanillaEntryCount = 0;
        this.polymer$lazyList.clear();
        this.polymer$states.clear();
        this.polymer$offset = Integer.MAX_VALUE;
        this.polymer$hasPolymer = false;
        this.polymer$locked = true;
    }
}

