/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.networking;

import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.compat.ServerTranslationUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerBlockPosStorage;
import eu.pb4.polymer.core.impl.interfaces.PolymerIdList;
import eu.pb4.polymer.core.impl.interfaces.RegistryExtension;
import eu.pb4.polymer.core.impl.networking.ServerPackets;
import eu.pb4.polymer.core.impl.networking.packets.BufferWritable;
import eu.pb4.polymer.core.impl.networking.packets.DebugBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.packets.IdValueEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerBlockEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerEntityEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerItemEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerItemGroupContent;
import eu.pb4.polymer.core.impl.networking.packets.PolymerTagEntry;
import eu.pb4.polymer.networking.api.PolymerServerNetworking;
import eu.pb4.polymer.networking.api.ServerPacketWriter;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_4076;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PolymerServerProtocol {
    public static void sendBlockUpdate(class_3244 player, class_2338 pos, class_2680 state) {
        PolymerBlock polymerBlock;
        PolymerBlock p;
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)ServerPackets.WORLD_SET_BLOCK_UPDATE);
        class_2248 class_22482 = state.method_26204();
        PolymerBlock polymerBlock2 = p = class_22482 instanceof PolymerBlock ? (polymerBlock = (PolymerBlock)class_22482) : null;
        if (PolymerImplUtils.POLYMER_STATES.contains(state) && version > -1 && (p == null || p.canSynchronizeToPolymerClient(player.field_14140))) {
            class_2540 buf = PolymerServerNetworking.buf((int)version);
            buf.method_10807(pos);
            buf.method_10804(class_2248.field_10651.method_10206((Object)state));
            player.method_14364((class_2596)new class_2658(ServerPackets.WORLD_SET_BLOCK_UPDATE, buf));
        }
    }

    public static void sendMultiBlockUpdate(class_3244 player, class_4076 chunkPos, short[] positions, class_2680[] blockStates) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)ServerPackets.WORLD_CHUNK_SECTION_UPDATE);
        if (version > -1) {
            LongArrayList list = new LongArrayList();
            for (int i = 0; i < blockStates.length; ++i) {
                PolymerBlock polymerBlock;
                PolymerBlock p;
                class_2248 class_22482 = blockStates[i].method_26204();
                PolymerBlock polymerBlock2 = p = class_22482 instanceof PolymerBlock ? (polymerBlock = (PolymerBlock)class_22482) : null;
                if (!PolymerImplUtils.POLYMER_STATES.contains(blockStates[i]) || p != null && !p.canSynchronizeToPolymerClient(player.field_14140)) continue;
                list.add((long)class_2248.field_10651.method_10206((Object)blockStates[i]) << 12 | (long)positions[i]);
            }
            if (!list.isEmpty()) {
                class_2540 buf = PolymerServerNetworking.buf((int)version);
                buf.method_36131(chunkPos);
                buf.method_10804(list.size());
                for (Long value : list) {
                    buf.method_10791(value.longValue());
                }
                player.method_14364((class_2596)new class_2658(ServerPackets.WORLD_CHUNK_SECTION_UPDATE, buf));
            }
        }
    }

    public static void sendSectionUpdate(class_3244 player, class_2818 chunk) {
        PolymerBlockPosStorage wci;
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)ServerPackets.WORLD_CHUNK_SECTION_UPDATE);
        if (version > -1 && (wci = (PolymerBlockPosStorage)chunk).polymer$hasAny()) {
            class_2826[] sections = chunk.method_12006();
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                PolymerBlockPosStorage storage = (PolymerBlockPosStorage)section;
                if (section == null || !storage.polymer$hasAny()) continue;
                class_2540 buf = PolymerServerNetworking.buf((int)version);
                ShortSet set = storage.polymer$getBackendSet();
                buf.method_36131(class_4076.method_18681((class_1923)chunk.method_12004(), (int)chunk.method_31604(i)));
                assert (set != null);
                LongArrayList data = new LongArrayList(set.size());
                for (Short pos : set) {
                    PolymerBlock polymerBlock;
                    PolymerBlock p;
                    int z;
                    int y;
                    int x = class_4076.method_30551((short)pos);
                    class_2680 state = section.method_12254(x, y = class_4076.method_30552((short)pos), z = class_4076.method_30553((short)pos));
                    class_2248 class_22482 = state.method_26204();
                    PolymerBlock polymerBlock2 = p = class_22482 instanceof PolymerBlock ? (polymerBlock = (PolymerBlock)class_22482) : null;
                    if (p != null && !p.canSynchronizeToPolymerClient(player.field_14140)) continue;
                    data.add((long)class_2248.field_10651.method_10206((Object)state) << 12 | (long)pos.shortValue());
                }
                buf.method_10804(data.size());
                data.forEach(arg_0 -> ((class_2540)buf).method_10791(arg_0));
                player.method_14364((class_2596)new class_2658(ServerPackets.WORLD_CHUNK_SECTION_UPDATE, buf));
            }
        }
    }

    public static void sendSyncPackets(class_3244 handler, boolean fullSync) {
        if (PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_STARTED) == -1) {
            return;
        }
        long startTime = System.nanoTime();
        handler.method_14364((class_2596)new class_2658(ServerPackets.SYNC_STARTED, PolymerServerNetworking.buf((int)0)));
        PolymerSyncUtils.ON_SYNC_STARTED.invoke(c -> c.accept(handler));
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_CLEAR);
        if (version != -1) {
            handler.method_14364((class_2596)new class_2658(ServerPackets.SYNC_CLEAR, PolymerServerNetworking.buf((int)version)));
        }
        if ((version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_INFO)) != -1) {
            class_2540 buf = PolymerServerNetworking.buf((int)version);
            buf.method_10804(PolymerImplUtils.getBlockStateOffset());
            handler.method_14364((class_2596)new class_2658(ServerPackets.SYNC_INFO, buf));
        }
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_ENCHANTMENT, PolymerServerProtocol.getServerSideEntries(class_7923.field_41176), false, (T type) -> new IdValueEntry(class_7923.field_41176.method_10206(type), class_7923.field_41176.method_10221(type)));
        PolymerSyncUtils.BEFORE_ITEM_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_ITEM, PolymerServerProtocol.getServerSideEntries(class_7923.field_41178), false, PolymerItemEntry::of);
        PolymerSyncUtils.AFTER_ITEM_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        if (fullSync) {
            PolymerSyncUtils.BEFORE_ITEM_GROUP_SYNC.invoke(listener -> listener.accept(handler, true));
            PolymerServerProtocol.sendCreativeSyncPackets(handler);
            PolymerSyncUtils.AFTER_ITEM_GROUP_SYNC.invoke(listener -> listener.accept(handler, true));
        }
        PolymerSyncUtils.BEFORE_BLOCK_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_BLOCK, PolymerServerProtocol.getServerSideEntries(class_7923.field_41175), false, PolymerBlockEntry::of);
        PolymerSyncUtils.AFTER_BLOCK_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerSyncUtils.BEFORE_BLOCK_STATE_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_BLOCKSTATE, PolymerServerProtocol.getServerSideEntries(class_2248.field_10651), false, PolymerBlockStateEntry::of);
        PolymerSyncUtils.AFTER_BLOCK_STATE_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerSyncUtils.BEFORE_ENTITY_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_ENTITY, PolymerServerProtocol.getServerSideEntries(class_7923.field_41177), false, PolymerEntityEntry::of);
        PolymerSyncUtils.AFTER_ENTITY_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_VILLAGER_PROFESSION, (class_2378)class_7923.field_41195);
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_STATUS_EFFECT, class_7923.field_41174);
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_BLOCK_ENTITY, class_7923.field_41181);
        PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_FLUID, (class_2378)class_7923.field_41173);
        if (fullSync) {
            PolymerServerProtocol.sendSync(handler, ServerPackets.SYNC_TAGS, class_7923.field_41167, true, PolymerTagEntry::of);
        }
        PolymerSyncUtils.ON_SYNC_CUSTOM.invoke(c -> c.accept(handler, fullSync));
        PolymerSyncUtils.ON_SYNC_FINISHED.invoke(c -> c.accept(handler));
        handler.method_14364((class_2596)new class_2658(ServerPackets.SYNC_FINISHED, PolymerServerNetworking.buf((int)0)));
        if (PolymerImpl.LOG_SYNC_TIME) {
            PolymerImpl.LOGGER.info((fullSync ? "Full" : "Partial") + " sync for {} took {} ms", (Object)handler.field_14140.method_7334().getName(), (Object)((double)((System.nanoTime() - startTime) / 10000L) / 100.0));
        }
    }

    private static <T> Collection<T> getServerSideEntries(class_2359<T> registry) {
        if (registry instanceof class_2378) {
            class_2378 registry1 = (class_2378)registry;
            return RegistryExtension.getPolymerEntries(registry1);
        }
        if (registry instanceof PolymerIdList) {
            return ((PolymerIdList)registry).polymer$getPolymerEntries();
        }
        return List.of();
    }

    private static void sendSync(class_3244 handler, class_2960 packetId, class_2378 registry) {
        PolymerServerProtocol.sendSync(handler, packetId, PolymerServerProtocol.getServerSideEntries(registry), false, (T type) -> new IdValueEntry(registry.method_10206(type), registry.method_10221(type)));
    }

    public static void sendCreativeSyncPackets(class_3244 handler) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_ITEM_GROUP_DEFINE);
        if (version != -1) {
            for (class_1761 group : PolymerItemGroupUtils.getItemGroups(handler.method_32311())) {
                PolymerServerProtocol.syncItemGroup(group, handler);
            }
            handler.method_14364((class_2596)new class_2658(ServerPackets.SYNC_ITEM_GROUP_APPLY_UPDATE, PolymerServerNetworking.buf((int)PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_ITEM_GROUP_APPLY_UPDATE))));
        }
    }

    public static void syncItemGroup(class_1761 group, class_3244 handler) {
        if (PolymerImpl.SYNC_MODDED_ENTRIES_POLYMC || PolymerItemGroupUtils.isPolymerItemGroup(group)) {
            PolymerServerProtocol.removeItemGroup(group, handler);
            PolymerServerProtocol.syncItemGroupDefinition(group, handler);
        }
        PolymerServerProtocol.syncItemGroupContents(group, handler);
    }

    public static void syncItemGroupContents(class_1761 group, class_3244 handler) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_ITEM_GROUP_CONTENTS_ADD);
        if (version != -1) {
            class_2540 buf = PolymerServerNetworking.buf((int)PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_ITEM_GROUP_CONTENTS_CLEAR));
            buf.method_10812(PolymerItemGroupUtils.getId(group));
            handler.method_14364((class_2596)new class_2658(ServerPackets.SYNC_ITEM_GROUP_CONTENTS_CLEAR, buf));
            try {
                PolymerItemGroupContent entry = PolymerItemGroupContent.of(group, handler);
                if (entry.isNonEmpty()) {
                    handler.method_14364(entry.toPacket(ServerPackets.SYNC_ITEM_GROUP_CONTENTS_ADD));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void syncItemGroupDefinition(class_1761 group, class_3244 handler) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.SYNC_ITEM_GROUP_DEFINE);
        if (version > -1 && (PolymerImpl.SYNC_MODDED_ENTRIES_POLYMC || PolymerItemGroupUtils.isPolymerItemGroup(group))) {
            class_2540 buf = PolymerServerNetworking.buf((int)version);
            buf.method_10812(PolymerItemGroupUtils.getId(group));
            buf.method_10805(ServerTranslationUtils.parseFor(handler, group.method_7737()));
            PolymerImplUtils.writeStack(buf, PolymerImplUtils.convertStack(group.method_7747(), handler.field_14140));
            handler.method_14364((class_2596)new class_2658(ServerPackets.SYNC_ITEM_GROUP_DEFINE, buf));
        }
    }

    public static void removeItemGroup(class_1761 group, class_3244 player) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)ServerPackets.SYNC_ITEM_GROUP_REMOVE);
        if (version > -1 && PolymerItemGroupUtils.isPolymerItemGroup(group)) {
            player.method_14364((class_2596)new class_2658(ServerPackets.SYNC_ITEM_GROUP_REMOVE, PolymerServerNetworking.buf((int)version).method_10812(PolymerItemGroupUtils.REGISTRY.getId(group))));
        }
    }

    public static void sendEntityInfo(class_3244 player, class_1297 entity) {
        PolymerServerProtocol.sendEntityInfo(player, entity.method_5628(), entity.method_5864());
    }

    public static void sendEntityInfo(class_3244 player, int id, class_1299<?> type) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)ServerPackets.WORLD_ENTITY);
        if (version != -1) {
            class_2540 buf = PolymerServerNetworking.buf((int)0);
            buf.method_10804(id);
            buf.method_10812(class_7923.field_41177.method_10221(type));
            player.method_14364((class_2596)new class_2658(ServerPackets.WORLD_ENTITY, buf));
        }
    }

    private static void sendSync(class_3244 handler, class_2960 id, int version, List<BufferWritable> entries) {
        handler.method_14364(new SyncPacket(List.copyOf(entries)).toPacket(id));
        entries.clear();
    }

    private static <T> void sendSync(class_3244 handler, class_2960 packetId, Iterable<T> iterable, boolean bypassPolymerCheck, Function<T, BufferWritable> writableFunction) {
        PolymerServerProtocol.sendSync(handler, packetId, iterable, bypassPolymerCheck, (T a, class_3244 b, int c) -> (BufferWritable)writableFunction.apply(a));
    }

    private static <T> void sendSync(class_3244 handler, class_2960 packetId, Iterable<T> iterable, boolean bypassPolymerCheck, BufferWritableCreator<T> writableFunction) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)packetId);
        if (iterable instanceof RegistryExtension && !bypassPolymerCheck) {
            iterable = ((RegistryExtension)((Object)iterable)).polymer$getEntries();
        }
        if (version != -1) {
            ArrayList<BufferWritable> entries = new ArrayList<BufferWritable>();
            for (T entry : iterable) {
                PolymerSyncedObject obj;
                if (bypassPolymerCheck && (!(entry instanceof PolymerSyncedObject) || !(obj = (PolymerSyncedObject)entry).canSynchronizeToPolymerClient(handler.field_14140))) continue;
                BufferWritable val = writableFunction.serialize(entry, handler, version);
                if (val != null) {
                    entries.add(val);
                }
                if (entries.size() <= 100) continue;
                PolymerServerProtocol.sendSync(handler, packetId, version, entries);
            }
            if (entries.size() != 0) {
                PolymerServerProtocol.sendSync(handler, packetId, version, entries);
            }
        }
    }

    public static void sendDebugValidateStatesPackets(class_3244 handler) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)ServerPackets.DEBUG_VALIDATE_STATES);
        if (version != -1) {
            PolymerServerProtocol.sendSync(handler, ServerPackets.DEBUG_VALIDATE_STATES, class_2248.field_10651, true, DebugBlockStateEntry::of);
        }
    }

    public static interface BufferWritableCreator<T> {
        public BufferWritable serialize(T var1, class_3244 var2, int var3);
    }

    private record SyncPacket(List<BufferWritable> entries) implements ServerPacketWriter
    {
        public void write(class_3244 handler, class_2540 buf, class_2960 packetId, int version) {
            buf.method_10804(this.entries.size());
            for (BufferWritable entry : this.entries) {
                entry.write(buf, version, handler);
            }
        }
    }
}

