/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.client.compat;

import eu.pb4.polymer.common.impl.entity.InternalEntityHelpers;
import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.api.client.ClientPolymerEntityType;
import eu.pb4.polymer.core.api.client.PolymerClientUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.client.compat.CompatUtils;
import java.util.Map;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.PairComponent;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class WthitCompatibility
implements IWailaPlugin {
    private static final class_2960 BLOCK_STATES = class_2960.method_12829((String)"waila:show_states");

    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)BlockOverride.INSTANCE, TooltipPosition.HEAD, class_2248.class, 100000);
        registrar.addComponent((IBlockComponentProvider)BlockOverride.INSTANCE, TooltipPosition.BODY, class_2248.class, 100000);
        registrar.addComponent((IBlockComponentProvider)BlockOverride.INSTANCE, TooltipPosition.TAIL, class_2248.class, 100000);
        registrar.addOverride((IBlockComponentProvider)BlockOverride.INSTANCE, class_2248.class, 1000);
        registrar.addComponent((IEntityComponentProvider)ItemEntityOverride.INSTANCE, TooltipPosition.HEAD, class_1542.class, 100000);
        registrar.addComponent((IEntityComponentProvider)ItemEntityOverride.INSTANCE, TooltipPosition.TAIL, class_1542.class, 100000);
        registrar.addComponent((IEntityComponentProvider)EntityOverride.INSTANCE, TooltipPosition.HEAD, class_1297.class, 100000);
        registrar.addComponent((IEntityComponentProvider)EntityOverride.INSTANCE, TooltipPosition.TAIL, class_1297.class, 100000);
        registrar.addEventListener((IEventListener)OtherOverrides.INSTANCE);
    }

    private static class BlockOverride
    implements IBlockComponentProvider {
        public static final BlockOverride INSTANCE = new BlockOverride();

        private BlockOverride() {
        }

        public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
            ClientPolymerBlock.State block = InternalClientRegistry.getBlockAt(accessor.getPosition());
            if (block != ClientPolymerBlock.NONE_STATE) {
                class_2487 nbtCompound;
                class_2586 blockEntity;
                class_2680 state = accessor.getWorld().method_8320(accessor.getPosition());
                class_1799 itemStack = state.method_26204().method_9574((class_1922)accessor.getWorld(), accessor.getPosition(), state);
                if (!itemStack.method_7960() && state.method_31709() && itemStack.method_7909() instanceof class_1809 && (blockEntity = accessor.getWorld().method_8321(accessor.getPosition())) != null && (nbtCompound = blockEntity.method_38244()).method_10545("SkullOwner")) {
                    itemStack.method_7948().method_10566("SkullOwner", (class_2520)nbtCompound.method_10562("SkullOwner"));
                }
                return new ItemComponent(itemStack);
            }
            return EmptyComponent.INSTANCE;
        }

        public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            ClientPolymerBlock.State block = InternalClientRegistry.getBlockAt(accessor.getPosition());
            if (block != ClientPolymerBlock.NONE_STATE) {
                IWailaConfig.Formatter formatting = IWailaConfig.get().getFormatter();
                tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatting.blockName((Object)block.block().name().getString()));
                if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
                    tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatting.registryName((Object)block.block().identifier().toString()));
                }
            }
        }

        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            ClientPolymerBlock.State block;
            if (config.getBoolean(BLOCK_STATES) && (block = InternalClientRegistry.getBlockAt(accessor.getPosition())) != ClientPolymerBlock.NONE_STATE) {
                for (Map.Entry<String, String> state : block.states().entrySet()) {
                    String value = state.getValue();
                    class_5250 valueText = class_2561.method_43470((String)value).method_10862(class_2583.field_24360.method_10977(value.equals("true") ? class_124.field_1060 : (value.equals("false") ? class_124.field_1061 : class_124.field_1070)));
                    tooltip.addLine((ITooltipComponent)new PairComponent((class_2561)class_2561.method_43470((String)state.getKey()), (class_2561)valueText));
                }
            }
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            ClientPolymerBlock.State block;
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME) && (block = InternalClientRegistry.getBlockAt(accessor.getPosition())) != ClientPolymerBlock.NONE_STATE) {
                String modName = IModInfo.get((class_2960)block.block().identifier()).getName();
                if (modName == null || modName.isEmpty() || modName.equals("Minecraft")) {
                    modName = InternalClientRegistry.getModName(block.block().identifier());
                }
                tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName((Object)modName));
            }
        }
    }

    private static final class ItemEntityOverride
    implements IEntityComponentProvider {
        public static final ItemEntityOverride INSTANCE = new ItemEntityOverride();

        private ItemEntityOverride() {
        }

        public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            class_2960 id;
            class_1799 stack;
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY) && (stack = ((class_1542)accessor.getEntity()).method_6983()).method_7985() && (id = PolymerItemUtils.getServerIdentifier(stack)) != null) {
                IWailaConfig.Formatter formatting = IWailaConfig.get().getFormatter();
                tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatting.registryName((Object)id));
            }
        }

        public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            class_2960 id;
            class_1799 stack;
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME) && (stack = ((class_1542)accessor.getEntity()).method_6983()).method_7985() && (id = PolymerItemUtils.getServerIdentifier(stack)) != null) {
                String modName = null;
                class_1792 regBlock = (class_1792)class_7923.field_41178.method_10223(id);
                if (regBlock != null) {
                    modName = IModInfo.get((class_1792)regBlock).getName();
                }
                if (modName == null || modName.isEmpty() || modName.equals("Minecraft") && !id.method_12836().equals("minecraft")) {
                    modName = InternalClientRegistry.getModName(id);
                }
                tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName((Object)modName));
            }
        }
    }

    private static final class EntityOverride
    implements IEntityComponentProvider {
        public static final EntityOverride INSTANCE = new EntityOverride();

        private EntityOverride() {
        }

        public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            class_1297 entity;
            ClientPolymerEntityType type;
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY) && (type = PolymerClientUtils.getEntityType(entity = accessor.getEntity())) != null) {
                IWailaConfig.Formatter formatting = IWailaConfig.get().getFormatter();
                tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatting.registryName((Object)type.identifier()));
            }
        }

        public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
            ClientPolymerEntityType type;
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME) && (type = PolymerClientUtils.getEntityType(accessor.getEntity())) != null) {
                String modName = null;
                class_1299 regBlock = (class_1299)class_7923.field_41177.method_10223(type.identifier());
                if (regBlock != null) {
                    modName = IModInfo.get((class_1297)InternalEntityHelpers.getEntity((class_1299)regBlock)).getName();
                }
                if (modName == null || modName.isEmpty() || modName.equals("Minecraft") && !type.identifier().method_12836().equals("minecraft")) {
                    modName = InternalClientRegistry.getModName(type.identifier());
                }
                tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName((Object)modName));
            }
        }
    }

    private static class OtherOverrides
    implements IEventListener {
        public static final OtherOverrides INSTANCE = new OtherOverrides();

        private OtherOverrides() {
        }

        @Nullable
        public String getHoveredItemModName(class_1799 stack, IPluginConfig config) {
            return CompatUtils.getModName(stack);
        }
    }
}

