/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.client.compat;

import eu.pb4.polymer.core.api.client.PolymerClientUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.client.interfaces.ClientItemGroupExtension;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7706;
import net.minecraft.class_7708;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CompatUtils {
    public static boolean areSamePolymerType(class_1799 a, class_1799 b) {
        return Objects.equals(CompatUtils.getItemId(a), CompatUtils.getItemId(b));
    }

    public static boolean areEqualItems(class_1799 a, class_1799 b) {
        if (!CompatUtils.areSamePolymerType(a, b)) {
            return false;
        }
        class_2487 nbtA = CompatUtils.getBackingNbt(a);
        class_2487 nbtB = CompatUtils.getBackingNbt(b);
        return Objects.equals(nbtA, nbtB);
    }

    @Nullable
    public static class_2487 getBackingNbt(class_1799 stack) {
        if (!stack.method_7985()) {
            return null;
        }
        class_2487 nbt = stack.method_7969();
        if (PolymerItemUtils.getServerIdentifier(stack) == null) {
            return nbt;
        }
        class_2487 maybeNbt = PolymerItemUtils.getPolymerNbt(stack);
        if (maybeNbt != null) {
            return maybeNbt;
        }
        maybeNbt = nbt.method_10562("PolyMcOriginal");
        return maybeNbt != null && maybeNbt.method_10573("tag", 10) ? maybeNbt.method_10562("tag") : null;
    }

    public static boolean isServerSide(class_1799 stack) {
        return PolymerItemUtils.getServerIdentifier(stack) != null;
    }

    public static Object getKey(class_1799 stack) {
        class_2960 id = PolymerItemUtils.getServerIdentifier(stack);
        if (id == null) {
            return stack.method_7909();
        }
        if (InternalClientRegistry.ITEMS.contains(id)) {
            return InternalClientRegistry.ITEMS.getKey(id);
        }
        return class_7923.field_41178.method_10223(id);
    }

    private static class_2960 getItemId(class_1799 stack) {
        class_2960 id = PolymerItemUtils.getServerIdentifier(stack);
        if (id == null) {
            return stack.method_7909().method_40131().method_40237().method_29177();
        }
        return id;
    }

    public static void iterateItems(Consumer<class_1799> consumer) {
        Set stacks = class_7708.method_47572();
        for (class_1761 group : class_7706.method_47341()) {
            if (group.method_47312() != class_1761.class_7916.field_41052) continue;
            stacks.addAll(((ClientItemGroupExtension)group).polymer$getStacksGroup());
            stacks.addAll(((ClientItemGroupExtension)group).polymer$getStacksSearch());
        }
        for (class_1799 stack : stacks) {
            consumer.accept(stack);
        }
    }

    public static void registerSyncReload(Runnable runnable) {
        if (PolymerImpl.IS_CLIENT) {
            PolymerClientUtils.ON_CLEAR.register((Object)CompatUtils.safeRunnable(runnable));
            PolymerClientUtils.ON_SEARCH_REBUILD.register((Object)CompatUtils.safeRunnable(runnable));
        }
    }

    private static Runnable safeRunnable(Runnable runnable) {
        return () -> {
            if (!class_310.method_1551().method_18854()) {
                class_310.method_1551().execute(() -> {
                    if (class_310.method_1551().field_1687 != null) {
                        runnable.run();
                    }
                });
                return;
            }
            if (class_310.method_1551().field_1687 != null) {
                runnable.run();
            }
        };
    }

    public static String getModName(class_1799 stack) {
        class_2960 id = PolymerItemUtils.getServerIdentifier(stack);
        if (id != null) {
            return InternalClientRegistry.getModName(id);
        }
        return null;
    }

    public record Key(class_2960 identifier) {
    }
}

