/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.entity;

import eu.pb4.polymer.common.impl.entity.InternalEntityHelpers;
import eu.pb4.polymer.core.api.entity.PolymerVillagerProfession;
import eu.pb4.polymer.core.impl.interfaces.EntityAttachedPacket;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.core.mixin.entity.EntityAccessor;
import eu.pb4.polymer.core.mixin.entity.PlayerListS2CPacketAccessor;
import eu.pb4.polymer.core.mixin.entity.PlayerSpawnS2CPacketAccessor;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2613;
import net.minecraft.class_2703;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class PolymerEntityUtils {
    private static final Set<class_1299<?>> ENTITY_TYPES = new ObjectOpenCustomHashSet(class_156.method_655());
    private static final Map<class_3852, PolymerVillagerProfession> VILLAGER_PROFESSIONS = new Object2ObjectOpenCustomHashMap(class_156.method_655());

    private PolymerEntityUtils() {
    }

    public static int requestFreeId() {
        return EntityAccessor.getCURRENT_ID().incrementAndGet();
    }

    public static void registerType(class_1299<?> ... types) {
        ENTITY_TYPES.addAll(Arrays.asList(types));
        for (class_1299<?> type : types) {
            RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41177, type);
        }
    }

    public static void registerProfession(class_3852 profession, PolymerVillagerProfession mapper) {
        VILLAGER_PROFESSIONS.put(profession, mapper);
        RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41195, (Object)profession);
    }

    @Nullable
    public static PolymerVillagerProfession getPolymerProfession(class_3852 profession) {
        return VILLAGER_PROFESSIONS.get(profession);
    }

    public static boolean isRegisteredEntityType(class_1299<?> type) {
        return ENTITY_TYPES.contains(type);
    }

    public static Int2ObjectMap<class_2945.class_2946<?>> getDefaultTrackedData(class_1299<?> type) {
        return InternalEntityHelpers.getExampleTrackedDataOfEntityType(type);
    }

    public static <T extends class_1297> Class<T> getEntityClass(class_1299<T> type) {
        return InternalEntityHelpers.getEntityClass(type);
    }

    public static boolean isLivingEntity(class_1299<?> type) {
        return InternalEntityHelpers.isLivingEntity(type);
    }

    public static boolean isMobEntity(class_1299<?> type) {
        return InternalEntityHelpers.isMobEntity(type);
    }

    public static class_2613 createPlayerSpawnPacket(int entityId, UUID uuid, double x, double y, double z, float yaw, float pitch) {
        try {
            class_2613 packet = (class_2613)UnsafeAccess.UNSAFE.allocateInstance(class_2613.class);
            PlayerSpawnS2CPacketAccessor accessor = (PlayerSpawnS2CPacketAccessor)packet;
            accessor.setId(entityId);
            accessor.setUuid(uuid);
            accessor.setYaw((byte)(yaw * 256.0f / 360.0f));
            accessor.setPitch((byte)(pitch * 256.0f / 360.0f));
            accessor.setX(x);
            accessor.setY(y);
            accessor.setZ(z);
            return packet;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_2613 createPlayerSpawnPacket(class_1297 entity) {
        return PolymerEntityUtils.createPlayerSpawnPacket(entity.method_5628(), entity.method_5667(), entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
    }

    public static class_2703 createMutablePlayerListPacket(EnumSet<class_2703.class_5893> actions) {
        class_2703 packet = new class_2703(actions, List.of());
        ((PlayerListS2CPacketAccessor)packet).setEntries(new ArrayList<class_2703.class_2705>());
        return packet;
    }

    public static boolean canHoldEntityContext(class_2596<?> packet) {
        return packet instanceof EntityAttachedPacket;
    }

    public static <T extends class_2596<class_2602>> T setEntityContext(T packet, class_1297 entity) {
        return EntityAttachedPacket.setIfEmpty(packet, entity);
    }

    public static <T extends class_2596<class_2602>> T forceSetEntityContext(T packet, class_1297 entity) {
        return EntityAttachedPacket.set(packet, entity);
    }

    @Nullable
    public static class_1297 getEntityContext(class_2596<?> packet) {
        return EntityAttachedPacket.get(packet);
    }

    public static void sendEntityType(class_3222 player, int entityId, class_1299<?> entityType) {
        PolymerServerProtocol.sendEntityInfo(player.field_13987, entityId, entityType);
    }
}

