/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.block;

import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.impl.interfaces.BlockStateExtra;
import eu.pb4.polymer.core.mixin.block.BlockEntityUpdateS2CPacketAccessor;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class PolymerBlockUtils {
    private static final class_2487 STATIC_COMPOUND = new class_2487();
    public static final int NESTED_DEFAULT_DISTANCE = 32;
    public static final Predicate<class_2680> IS_POLYMER_BLOCK_STATE_PREDICATE = state -> state.method_26204() instanceof PolymerBlock;
    public static final BooleanEvent<MineEventListener> SERVER_SIDE_MINING_CHECK = new BooleanEvent();
    public static final SimpleEvent<BreakingProgressListener> BREAKING_PROGRESS_UPDATE = new SimpleEvent();
    public static final BooleanEvent<BiPredicate<class_3218, class_4076>> SEND_LIGHT_UPDATE_PACKET = new BooleanEvent();
    private static final Set<class_2591<?>> BLOCK_ENTITY_TYPES = new ObjectOpenCustomHashSet(class_156.method_655());
    private static boolean requireStrictBlockUpdates = false;

    private PolymerBlockUtils() {
    }

    public static void registerBlockEntity(class_2591<?> ... types) {
        BLOCK_ENTITY_TYPES.addAll(Arrays.asList(types));
        for (class_2591<?> type : types) {
            RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41181, type);
        }
    }

    public static boolean isPolymerBlockEntityType(class_2591<?> type) {
        return BLOCK_ENTITY_TYPES.contains(type);
    }

    public static boolean forceLightUpdates(class_2680 blockState) {
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof PolymerBlock) {
            PolymerBlock virtualBlock = (PolymerBlock)class_22482;
            if (virtualBlock.forceLightUpdates(blockState)) {
                return true;
            }
            return ((BlockStateExtra)blockState).polymer$isPolymerLightSource();
        }
        return false;
    }

    public static class_2680 getPolymerBlockState(class_2680 state) {
        return PolymerBlockUtils.getPolymerBlockState(state, null);
    }

    public static class_2680 getPolymerBlockState(class_2680 state, @Nullable class_3222 player) {
        return BlockMapper.getFrom(player).toClientSideState(state, player);
    }

    public static class_2248 getPolymerBlock(class_2248 block, @Nullable class_3222 player) {
        return BlockMapper.getFrom(player).toClientSideBlock(block, player);
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance) {
        PolymerBlock newBlock;
        class_2248 class_22482;
        class_2680 out = block.getPolymerBlockState(blockState);
        for (int req = 0; (class_22482 = out.method_26204()) instanceof PolymerBlock && (newBlock = (PolymerBlock)class_22482) != block && req < maxDistance; ++req) {
            out = newBlock.getPolymerBlockState(out);
        }
        return out;
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, int maxDistance, @Nullable class_3222 player) {
        PolymerBlock newBlock;
        class_2248 class_22482;
        if (player == null) {
            return PolymerBlockUtils.getBlockStateSafely(block, blockState, maxDistance);
        }
        class_2680 out = block.getPolymerBlockState(blockState, player);
        for (int req = 0; (class_22482 = out.method_26204()) instanceof PolymerBlock && (newBlock = (PolymerBlock)class_22482) != block && req < maxDistance; ++req) {
            out = newBlock.getPolymerBlockState(blockState, player);
        }
        return out;
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState, @Nullable class_3222 player) {
        return PolymerBlockUtils.getBlockStateSafely(block, blockState, 32, player);
    }

    public static class_2680 getBlockStateSafely(PolymerBlock block, class_2680 blockState) {
        return PolymerBlockUtils.getBlockStateSafely(block, blockState, 32);
    }

    public static class_2248 getBlockSafely(PolymerBlock block, class_2680 state, int maxDistance, @Nullable class_3222 player) {
        PolymerBlock newBlock;
        class_2248 out;
        class_2248 class_22482 = out = player != null ? block.getPolymerBlock(state, player) : block.getPolymerBlock(state);
        for (int req = 0; out instanceof PolymerBlock && (newBlock = (PolymerBlock)out) != block && req < maxDistance; ++req) {
            out = player != null ? newBlock.getPolymerBlock(out.method_9564(), player) : newBlock.getPolymerBlock(state);
        }
        return out;
    }

    public static class_2248 getBlockSafely(PolymerBlock block, class_2680 state, @Nullable class_3222 player) {
        return PolymerBlockUtils.getBlockSafely(block, state, 32, player);
    }

    public static class_2248 getBlockSafely(PolymerBlock block, class_2680 state, int maxDistance) {
        return PolymerBlockUtils.getBlockSafely(block, state, maxDistance, null);
    }

    public static class_2248 getBlockSafely(PolymerBlock block, class_2680 state) {
        return PolymerBlockUtils.getBlockSafely(block, state, 32);
    }

    public static class_2622 createBlockEntityPacket(class_2338 pos, class_2591<?> type, @Nullable class_2487 nbtCompound) {
        return BlockEntityUpdateS2CPacketAccessor.createBlockEntityUpdateS2CPacket(pos.method_10062(), type, nbtCompound != null ? nbtCompound : STATIC_COMPOUND);
    }

    @ApiStatus.Experimental
    public static void requireStrictBlockUpdates() {
        requireStrictBlockUpdates = true;
    }

    public static boolean isStrictBlockUpdateRequired() {
        return requireStrictBlockUpdates;
    }

    @FunctionalInterface
    public static interface BreakingProgressListener {
        public boolean onBreakingProgressUpdate(class_3222 var1, class_2338 var2, class_2680 var3, int var4);
    }

    @FunctionalInterface
    public static interface MineEventListener {
        public boolean onBlockMine(class_2680 var1, class_2338 var2, class_3222 var3);
    }
}

