/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.blockview.client;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.blockview.client.RenderDataMapConsumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_6850;
import net.minecraft.class_853;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_6850.class})
public abstract class ChunkRendererRegionBuilderMixin {
    private static final AtomicInteger ERROR_COUNTER = new AtomicInteger();
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkRendererRegionBuilderMixin.class);

    @Inject(method={"build"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void createDataMap(class_1937 world, class_2338 startPos, class_2338 endPos, int offset, CallbackInfoReturnable<class_853> cir, int startX, int startZ, int endX, int endZ, class_6850.class_6851[][] chunksXZ) {
        class_853 rendererRegion = (class_853)cir.getReturnValue();
        if (rendererRegion == null) {
            return;
        }
        Long2ObjectOpenHashMap<Object> map = null;
        class_6850.class_6851[][] class_6851Array = chunksXZ;
        int n = class_6851Array.length;
        for (int i = 0; i < n; ++i) {
            class_6850.class_6851[] chunksZ;
            block3: for (class_6850.class_6851 chunk : chunksZ = class_6851Array[i]) {
                while (true) {
                    try {
                        map = ChunkRendererRegionBuilderMixin.mapChunk(chunk.method_39971(), startPos, endPos, map);
                        continue block3;
                    }
                    catch (ConcurrentModificationException e) {
                        int count = ERROR_COUNTER.incrementAndGet();
                        if (count > 5) continue;
                        LOGGER.warn("[Block Entity Render Data] Encountered CME during render region build. A mod is accessing or changing chunk data outside the main thread. Retrying.", (Throwable)e);
                        if (count != 5) continue;
                        LOGGER.info("[Block Entity Render Data] Subsequent exceptions will be suppressed.");
                        continue;
                    }
                    break;
                }
            }
        }
        if (map != null) {
            ((RenderDataMapConsumer)rendererRegion).fabric_acceptRenderDataMap((Long2ObjectMap<Object>)map);
        }
    }

    @Unique
    private static Long2ObjectOpenHashMap<Object> mapChunk(class_2818 chunk, class_2338 posFrom, class_2338 posTo, Long2ObjectOpenHashMap<Object> map) {
        int xMin = posFrom.method_10263();
        int xMax = posTo.method_10263();
        int yMin = posFrom.method_10264();
        int yMax = posTo.method_10264();
        int zMin = posFrom.method_10260();
        int zMax = posTo.method_10260();
        for (Map.Entry entry : chunk.method_12214().entrySet()) {
            Object data;
            class_2338 pos = (class_2338)entry.getKey();
            if (pos.method_10263() < xMin || pos.method_10263() > xMax || pos.method_10264() < yMin || pos.method_10264() > yMax || pos.method_10260() < zMin || pos.method_10260() > zMax || (data = ((class_2586)entry.getValue()).getRenderData()) == null) continue;
            if (map == null) {
                map = new Long2ObjectOpenHashMap();
            }
            map.put(pos.method_10063(), data);
        }
        return map;
    }
}

