/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.yabn.reader;

import com.teamresourceful.yabn.utils.ByteArrayList;
import com.teamresourceful.yabn.utils.ByteUtils;
import java.nio.charset.StandardCharsets;

public interface ByteReader {
    public byte peek();

    public void advance();

    public byte readByte();

    default public char readChar() {
        return (char)this.readByte();
    }

    default public boolean readBoolean() {
        return this.readByte() == 1;
    }

    default public short readShort() {
        return ByteUtils.fromBytes(this.readByte(), this.readByte());
    }

    default public int readInt() {
        return ByteUtils.fromBytes(this.readByte(), this.readByte(), this.readByte(), this.readByte());
    }

    default public long readLong() {
        return ByteUtils.fromBytes(this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte());
    }

    default public int readVInt() {
        byte curr = this.readByte();
        int num = curr & 0x7F;
        while ((curr & 0x80) != 0) {
            curr = this.readByte();
            num = num << 7 | curr & 0x7F;
        }
        return num;
    }

    default public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    default public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    default public String readString() {
        ByteArrayList bytes = new ByteArrayList();
        while (this.peek() != 0) {
            bytes.add(this.readByte());
        }
        this.advance();
        return new String(bytes.toArray(), StandardCharsets.UTF_8);
    }

    default public String readNullString() {
        int nulls = this.readVInt();
        ByteArrayList bytes = new ByteArrayList();
        while (nulls != 0 || this.peek() != 0) {
            byte c = this.readByte();
            bytes.add(c);
            if (c != 0) continue;
            --nulls;
        }
        this.advance();
        return new String(bytes.toArray(), StandardCharsets.UTF_8);
    }
}

