/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.yabn;

import com.teamresourceful.yabn.YabnCompressor;
import com.teamresourceful.yabn.elements.YabnArray;
import com.teamresourceful.yabn.elements.YabnElement;
import com.teamresourceful.yabn.elements.YabnException;
import com.teamresourceful.yabn.elements.YabnObject;
import com.teamresourceful.yabn.elements.YabnPrimitive;
import com.teamresourceful.yabn.elements.YabnType;
import com.teamresourceful.yabn.reader.ByteReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public final class YabnParser {
    private YabnParser() {
        throw new IllegalStateException("Utility class");
    }

    public static YabnElement parseCompress(ByteReader data) throws YabnException {
        return YabnCompressor.compress(YabnParser.parse(data));
    }

    public static YabnElement parse(ByteReader data) throws YabnException {
        try {
            YabnType type = YabnType.fromId(data.readByte());
            return YabnParser.getElement(type, data);
        }
        catch (Exception exception) {
            if (exception instanceof YabnException) {
                throw exception;
            }
            if (exception instanceof ArrayIndexOutOfBoundsException) {
                throw new YabnException("Array index out of bounds, make sure there is an EOD byte at the end of the data that requires it.");
            }
            throw new YabnException(exception.getMessage());
        }
    }

    private static YabnElement readyObject(ByteReader data) {
        LinkedHashMap<String, YabnElement> obj = new LinkedHashMap<String, YabnElement>();
        while (data.peek() != 0) {
            YabnType type = YabnType.fromId(data.readByte());
            String key = data.readString();
            obj.put(key, YabnParser.getElement(type, data));
        }
        data.advance();
        return new YabnObject(obj);
    }

    private static YabnArray readSizedArray(ByteReader data, YabnType arrayType) {
        int size = data.readVInt();
        ArrayList<YabnElement> elements = new ArrayList<YabnElement>(size);
        for (int i = 0; i < size; ++i) {
            YabnType type = arrayType == null ? YabnType.fromId(data.readByte()) : arrayType;
            elements.add(YabnParser.getElement(type, data));
        }
        return new YabnArray(elements);
    }

    private static YabnArray readArray(ByteReader data) {
        ArrayList<YabnElement> elements = new ArrayList<YabnElement>();
        while (data.peek() != 0) {
            YabnType type = YabnType.fromId(data.readByte());
            elements.add(YabnParser.getElement(type, data));
        }
        data.advance();
        return new YabnArray(elements);
    }

    private static YabnElement getElement(YabnType type, ByteReader data) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case YabnType.NULL -> YabnPrimitive.ofNull();
            case YabnType.BOOLEAN_TRUE -> YabnPrimitive.ofBoolean(true);
            case YabnType.BOOLEAN_FALSE -> YabnPrimitive.ofBoolean(false);
            case YabnType.BYTE -> YabnPrimitive.ofByte(data.readByte());
            case YabnType.SHORT -> YabnPrimitive.ofShort(data.readShort());
            case YabnType.INT -> YabnPrimitive.ofInt(data.readInt());
            case YabnType.LONG -> YabnPrimitive.ofLong(data.readLong());
            case YabnType.FLOAT -> YabnPrimitive.ofFloat(data.readFloat());
            case YabnType.DOUBLE -> YabnPrimitive.ofDouble(data.readDouble());
            case YabnType.STRING -> YabnPrimitive.ofString(data.readString());
            case YabnType.NULL_STRING -> YabnPrimitive.ofString(data.readNullString());
            case YabnType.EMPTY_STRING -> YabnPrimitive.ofString("");
            case YabnType.ARRAY -> YabnParser.readArray(data);
            case YabnType.TYPED_ARRAY, YabnType.DATALESS_TYPED_ARRAY -> YabnParser.readSizedArray(data, YabnType.fromId(data.readByte()));
            case YabnType.OBJECT -> YabnParser.readyObject(data);
            case YabnType.EMPTY_ARRAY -> new YabnArray();
            case YabnType.EMPTY_OBJECT -> new YabnObject();
        };
    }
}

