/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class WButton
extends WWidget {
    private static final class_2960 DARK_WIDGETS_LOCATION = new class_2960("libgui", "textures/widget/dark_widgets.png");
    private static final int BUTTON_HEIGHT = 20;
    private static final int ICON_SPACING = 2;
    @Nullable
    private class_2561 label;
    protected int color = 0x404040;
    protected int darkmodeColor = 0x404040;
    protected int iconSize = 16;
    private boolean enabled = true;
    protected HorizontalAlignment alignment = HorizontalAlignment.CENTER;
    @Nullable
    private Runnable onClick;
    @Nullable
    private Icon icon = null;

    public WButton() {
    }

    public WButton(@Nullable Icon icon) {
        this.icon = icon;
    }

    public WButton(@Nullable class_2561 label) {
        this.label = label;
    }

    public WButton(@Nullable Icon icon, @Nullable class_2561 label) {
        this.icon = icon;
        this.label = label;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        boolean hovered = mouseX >= 0 && mouseY >= 0 && mouseX < this.getWidth() && mouseY < this.getHeight();
        int state = 1;
        if (!this.enabled) {
            state = 0;
        } else if (hovered || this.isFocused()) {
            state = 2;
        }
        float px = 0.00390625f;
        float buttonLeft = 0.0f * px;
        float buttonTop = (float)(46 + state * 20) * px;
        int halfWidth = this.getWidth() / 2;
        if (halfWidth > 198) {
            halfWidth = 198;
        }
        float buttonWidth = (float)halfWidth * px;
        float buttonHeight = 20.0f * px;
        float buttonEndLeft = (float)(200 - this.getWidth() / 2) * px;
        class_2960 texture = WButton.getTexture(this);
        ScreenDrawing.texturedRect(context, x, y, this.getWidth() / 2, 20, texture, buttonLeft, buttonTop, buttonLeft + buttonWidth, buttonTop + buttonHeight, -1);
        ScreenDrawing.texturedRect(context, x + this.getWidth() / 2, y, this.getWidth() / 2, 20, texture, buttonEndLeft, buttonTop, 200.0f * px, buttonTop + buttonHeight, -1);
        if (this.icon != null) {
            this.icon.paint(context, x + 2, y + (20 - this.iconSize) / 2, this.iconSize);
        }
        if (this.label != null) {
            int color = 0xE0E0E0;
            if (!this.enabled) {
                color = 0xA0A0A0;
            }
            int xOffset = this.icon != null && this.alignment == HorizontalAlignment.LEFT ? 2 + this.iconSize + 2 : 0;
            ScreenDrawing.drawStringWithShadow(context, this.label.method_30937(), this.alignment, x + xOffset, y + 6, this.width, color);
        }
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        super.onClick(x, y, button);
        if (this.enabled && this.isWithinBounds(x, y)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            if (this.onClick != null) {
                this.onClick.run();
            }
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        if (WButton.isActivationKey(ch)) {
            this.onClick(0, 0, 0);
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Nullable
    public Runnable getOnClick() {
        return this.onClick;
    }

    public WButton setOnClick(@Nullable Runnable onClick) {
        this.onClick = onClick;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    public class_2561 getLabel() {
        return this.label;
    }

    public WButton setLabel(class_2561 label) {
        this.label = label;
        return this;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public WButton setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public WButton setIconSize(int iconSize) {
        this.iconSize = iconSize;
        return this;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public WButton setIcon(@Nullable Icon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_339.method_32602((class_2561)this.getLabel()));
        if (this.isEnabled()) {
            if (this.isFocused()) {
                builder.method_37034(class_6381.field_33791, NarrationMessages.Vanilla.BUTTON_USAGE_FOCUSED);
            } else if (this.isHovered()) {
                builder.method_37034(class_6381.field_33791, NarrationMessages.Vanilla.BUTTON_USAGE_HOVERED);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class_2960 getTexture(WWidget widget) {
        return widget.shouldRenderInDarkMode() ? DARK_WIDGETS_LOCATION : class_339.field_22757;
    }
}

