/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.cactusconfig;

import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleInputOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleOption;
import dev.lambdaurora.spruceui.option.SpruceFloatInputOption;
import dev.lambdaurora.spruceui.option.SpruceIntegerInputOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.option.SpruceStringOption;
import dev.lambdaurora.spruceui.option.SpruceToggleBooleanOption;
import io.github.thepoultryman.cactusconfig.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class OptionHolder {
    public final List<SpruceOption> spruceOptions = new ArrayList<SpruceOption>();
    private final class_2561 title;
    private final class_2561 description;

    public OptionHolder(class_2561 title, @Nullable class_2561 description) {
        this.title = title;
        this.description = description;
        if (!ConfigUtil.isServerEnvironment()) {
            this.spruceOptions.add((SpruceOption)new SpruceSeparatorOption("cactus_config.title_separator", false, null));
        }
    }

    public void addSpruceToggleOption(String optionName, Supplier<Boolean> getMethod, Consumer<Boolean> setMethod, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceToggleBooleanOption("cactus_config.option." + optionName, getMethod, setMethod, hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public void addSpruceStringOption(String optionName, Supplier<String> getMethod, Consumer<String> setMethod, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceStringOption("cactus_config.option." + optionName, getMethod, setMethod, s -> true, hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public void addSpruceStringOption(String optionName, Supplier<String> getMethod, Consumer<String> setMethod, boolean hasTooltip, Predicate<String> predicate) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceStringOption("cactus_config.option." + optionName, getMethod, setMethod, predicate, hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public void addSpruceIntegerOption(String optionName, Supplier<Integer> getMethod, Consumer<Integer> setMethod, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceIntegerInputOption("cactus_config.option." + optionName, getMethod, setMethod, hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public void addSpruceFloatOption(String optionName, Supplier<Float> getMethod, Consumer<Float> setMethod, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceFloatInputOption("cactus_config.option." + optionName, getMethod, setMethod, hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public void addSpruceDoubleOption(String optionName, Supplier<Double> getMethod, Consumer<Double> setMethod, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceDoubleInputOption("cactus_config.option." + optionName, getMethod, setMethod, hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public void addSpruceSliderOption(String optionName, double min, double max, float step, Supplier<Double> getMethod, Consumer<Double> setMethod, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceDoubleOption("cactus_config.option." + optionName, min, max, step, getMethod, setMethod, option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.valueOf(getMethod.get()))), hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public <T extends Enum<?>> void addSpruceCycleOption(String optionName, Supplier<T> getMethod, Consumer<Integer> setMethod, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceCyclingOption("cactus_config.option." + optionName, setMethod, option -> option.getDisplayText(ConfigUtil.getCycleOptionText(optionName, (Enum)getMethod.get())), hasTooltip ? class_2561.method_43471((String)("cactus_config.option.desc." + optionName)) : null));
    }

    public void addSpruceSeparator(String separatorName, boolean showTitle, boolean hasTooltip) {
        if (ConfigUtil.isServerEnvironment()) {
            return;
        }
        this.spruceOptions.add((SpruceOption)new SpruceSeparatorOption("cactus_config.separator." + separatorName, showTitle, hasTooltip ? class_2561.method_43471((String)("cactus_config.separator.tooltip." + separatorName)) : null));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public class_2561 getDescription() {
        return this.description == null ? null : this.description.method_27662().method_27692(class_124.field_1080);
    }
}

