/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.cactusconfig;

import com.electronwill.nightconfig.core.file.FileConfig;
import io.github.thepoultryman.cactusconfig.CactusConfig;
import io.github.thepoultryman.cactusconfig.OptionHolder;
import io.github.thepoultryman.cactusconfig.Options;
import io.github.thepoultryman.cactusconfig.util.CactusUtil;
import io.github.thepoultryman.cactusconfig.util.ConfigUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;

public abstract class ConfigManager {
    public final String fileName;
    public FileConfig config = null;
    public final boolean loadOnServer;
    public final Map<String, OptionHolder> optionHolders = new LinkedHashMap<String, OptionHolder>();

    public ConfigManager(String fileName, boolean loadOnServer) {
        this.fileName = fileName;
        this.loadOnServer = loadOnServer;
        if (!ConfigUtil.isServerEnvironment()) {
            this.config = this.buildFileConfig();
        } else if (ConfigUtil.isServerEnvironment() && this.loadOnServer) {
            this.config = this.buildFileConfig();
        }
    }

    private FileConfig buildFileConfig() {
        return FileConfig.builder((String)(FabricLoader.getInstance().getConfigDir() + "/" + this.fileName + ".toml")).defaultResource("/" + this.fileName + ".toml").build();
    }

    public void loadConfig() {
        if (this.config != null) {
            this.config.load();
            this.load();
            for (Field field : this.getClass().getDeclaredFields()) {
                Annotation annotation;
                if (field.isAnnotationPresent(Options.OptionHolder.class)) {
                    try {
                        CactusConfig.LOGGER.info(field.getName());
                        this.optionHolders.put(field.getName(), (OptionHolder)field.get(this));
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    continue;
                }
                if (field.isAnnotationPresent(Options.Separator.class)) {
                    annotation = field.getAnnotation(Options.Separator.class);
                    if (this.optionHolders.get(annotation.tab()) == null) continue;
                    field.setAccessible(true);
                    CactusUtil.ConfigOption separator = null;
                    try {
                        separator = (CactusUtil.ConfigOption)field.get(this);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    if (separator == null) continue;
                    this.optionHolders.get(annotation.tab()).addSpruceSeparator(field.getName(), separator.showTitle, separator.hasTooltip);
                    continue;
                }
                if (field.isAnnotationPresent(Options.Boolean.class)) {
                    annotation = field.getAnnotation(Options.Boolean.class);
                    field.setAccessible(true);
                    this.getAndCreateBooleanOption(this.optionHolders.get(annotation.tab()), annotation.tab() + "." + field.getName(), annotation.defaultValue(), () -> this.lambda$loadConfig$0(field, (Options.Boolean)annotation), arg_0 -> this.lambda$loadConfig$1(field, (Options.Boolean)annotation, arg_0), annotation.tooltip());
                    continue;
                }
                if (field.isAnnotationPresent(Options.StringField.class)) {
                    annotation = field.getAnnotation(Options.StringField.class);
                    field.setAccessible(true);
                    this.getAndCreateStringOption(this.optionHolders.get(annotation.tab()), annotation.tab() + "." + field.getName(), annotation.defaultValue(), () -> this.lambda$loadConfig$2(field, (Options.StringField)annotation), arg_0 -> this.lambda$loadConfig$3(field, (Options.StringField)annotation, arg_0), annotation.tooltip());
                    continue;
                }
                if (field.isAnnotationPresent(Options.Integer.class)) {
                    annotation = field.getAnnotation(Options.Integer.class);
                    field.setAccessible(true);
                    this.getAndCreateIntegerOption(this.optionHolders.get(annotation.tab()), annotation.tab() + "." + field.getName(), annotation.defaultValue(), () -> this.lambda$loadConfig$4(field, (Options.Integer)annotation), arg_0 -> this.lambda$loadConfig$5(field, (Options.Integer)annotation, arg_0), annotation.tooltip());
                    continue;
                }
                if (field.isAnnotationPresent(Options.FloatField.class)) {
                    annotation = field.getAnnotation(Options.FloatField.class);
                    field.setAccessible(true);
                    this.getAndCreateFloatOption(this.optionHolders.get(annotation.tab()), annotation.tab() + "." + field.getName(), annotation.defaultValue(), () -> this.lambda$loadConfig$6(field, (Options.FloatField)annotation), arg_0 -> this.lambda$loadConfig$7(field, (Options.FloatField)annotation, arg_0), annotation.tooltip());
                    continue;
                }
                if (field.isAnnotationPresent(Options.DoubleField.class)) {
                    annotation = field.getAnnotation(Options.DoubleField.class);
                    field.setAccessible(true);
                    this.getAndCreateDoubleOption(this.optionHolders.get(annotation.tab()), annotation.tab() + "." + field.getName(), annotation.defaultValue(), () -> this.lambda$loadConfig$8(field, (Options.DoubleField)annotation), arg_0 -> this.lambda$loadConfig$9(field, (Options.DoubleField)annotation, arg_0), annotation.tooltip());
                    continue;
                }
                if (!field.isAnnotationPresent(Options.Slider.class)) continue;
                annotation = field.getAnnotation(Options.Slider.class);
                field.setAccessible(true);
                this.getAndCreateSliderOption(this.optionHolders.get(annotation.tab()), annotation.tab() + "." + field.getName(), annotation.defaultValue(), annotation.min(), annotation.max(), annotation.step(), () -> this.lambda$loadConfig$10(field, (Options.Slider)annotation), arg_0 -> this.lambda$loadConfig$11(field, (Options.Slider)annotation, arg_0), annotation.tooltip());
            }
        }
    }

    protected void load() {
    }

    public abstract boolean canReset();

    public void reset() {
        for (Field field : this.getClass().getDeclaredFields()) {
            Annotation annotation;
            if (field.isAnnotationPresent(Options.Boolean.class)) {
                annotation = field.getAnnotation(Options.Boolean.class);
                try {
                    field.setBoolean(this, annotation.defaultValue());
                    this.setConfigOption(annotation.tab() + "." + field.getName(), annotation.defaultValue());
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            if (field.isAnnotationPresent(Options.StringField.class)) {
                annotation = field.getAnnotation(Options.StringField.class);
                field.setAccessible(true);
                try {
                    field.set(this, annotation.defaultValue());
                    this.setConfigOption(annotation.tab() + "." + field.getName(), annotation.defaultValue());
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            if (field.isAnnotationPresent(Options.Integer.class)) {
                annotation = field.getAnnotation(Options.Integer.class);
                field.setAccessible(true);
                try {
                    field.setInt(this, annotation.defaultValue());
                    this.setConfigOption(annotation.tab() + "." + field.getName(), annotation.defaultValue());
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            if (field.isAnnotationPresent(Options.FloatField.class)) {
                annotation = field.getAnnotation(Options.FloatField.class);
                field.setAccessible(true);
                try {
                    field.setFloat(this, annotation.defaultValue());
                    this.setConfigOption(annotation.tab() + "." + field.getName(), Float.valueOf(annotation.defaultValue()));
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            if (field.isAnnotationPresent(Options.DoubleField.class)) {
                annotation = field.getAnnotation(Options.DoubleField.class);
                field.setAccessible(true);
                try {
                    field.setDouble(this, annotation.defaultValue());
                    this.setConfigOption(annotation.tab() + "." + field.getName(), annotation.defaultValue());
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            if (!field.isAnnotationPresent(Options.Slider.class)) continue;
            annotation = field.getAnnotation(Options.Slider.class);
            field.setAccessible(true);
            try {
                field.setDouble(this, annotation.defaultValue());
                this.setConfigOption(annotation.tab() + "." + field.getName(), annotation.defaultValue());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public OptionHolder[] getOptionHolders() {
        return this.optionHolders.values().toArray(new OptionHolder[0]);
    }

    public void getAndCreateBooleanOption(OptionHolder optionHolder, String path, boolean defaultValue, Supplier<Boolean> getter, Consumer<Boolean> setter, boolean hasTooltip) {
        boolean value = (Boolean)this.config.getOrElse(path, (Object)defaultValue);
        setter.accept(value);
        optionHolder.addSpruceToggleOption(path, getter, setter, hasTooltip);
    }

    public void getAndCreateStringOption(OptionHolder optionHolder, String path, String defaultValue, Supplier<String> getter, Consumer<String> setter, boolean hasTooltip) {
        String value = (String)this.config.getOrElse(path, (Object)defaultValue);
        setter.accept(value);
        optionHolder.addSpruceStringOption(path, getter, setter, hasTooltip);
    }

    public void getAndCreateStringOption(OptionHolder optionHolder, String path, String defaultValue, Supplier<String> getter, Consumer<String> setter, boolean hasTooltip, Predicate<String> predicate) {
        String value = (String)this.config.getOrElse(path, (Object)defaultValue);
        setter.accept(value);
        optionHolder.addSpruceStringOption(path, getter, setter, hasTooltip, predicate);
    }

    public void getAndCreateIntegerOption(OptionHolder optionHolder, String path, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter, boolean hasTooltip) {
        int value = (Integer)this.config.getOrElse(path, (Object)defaultValue);
        setter.accept(value);
        optionHolder.addSpruceIntegerOption(path, getter, setter, hasTooltip);
    }

    public void getAndCreateFloatOption(OptionHolder optionHolder, String path, double defaultValue, Supplier<Float> getter, Consumer<Float> setter, boolean hasTooltip) {
        double value = (Double)this.config.getOrElse(path, (Object)defaultValue);
        setter.accept(Float.valueOf((float)value));
        optionHolder.addSpruceFloatOption(path, getter, setter, hasTooltip);
    }

    public void getAndCreateDoubleOption(OptionHolder optionHolder, String path, double defaultValue, Supplier<Double> getter, Consumer<Double> setter, boolean hasTooltip) {
        double value = (Double)this.config.getOrElse(path, (Object)defaultValue);
        setter.accept(value);
        optionHolder.addSpruceDoubleOption(path, getter, setter, hasTooltip);
    }

    public void getAndCreateSliderOption(OptionHolder optionHolder, String path, double defaultValue, double min, double max, float step, Supplier<Double> getter, Consumer<Double> setter, boolean hasTooltip) {
        double value = (Double)this.config.getOrElse(path, (Object)defaultValue);
        setter.accept(value);
        optionHolder.addSpruceSliderOption(path, min, max, step, getter, setter, hasTooltip);
    }

    public <T extends Enum<?>> void getAndCreateCycleOption(OptionHolder optionHolder, String path, T defaultValue, Supplier<T> getter, Consumer<T> setter, Consumer<Integer> cycleMethod, boolean hasTooltip) {
        Enum value = (Enum)this.config.getOrElse(path, defaultValue);
        setter.accept(value);
        optionHolder.addSpruceCycleOption(path, getter, cycleMethod, hasTooltip);
    }

    public void setConfigOption(String optionPath, Object optionValue) {
        this.config.set(optionPath, optionValue);
        this.config.save();
    }

    public <T> T getConfigOption(String optionPath, T defaultValue) {
        if (this.config.contains(optionPath)) {
            return (T)this.config.get(optionPath);
        }
        Object obj = this.config.set(optionPath, defaultValue);
        this.config.save();
        return (T)obj;
    }

    private /* synthetic */ void lambda$loadConfig$11(Field field, Options.Slider annotation, Double newValue) {
        try {
            field.setDouble(this, newValue);
            this.setConfigOption(annotation.tab() + "." + field.getName(), newValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private /* synthetic */ Double lambda$loadConfig$10(Field field, Options.Slider annotation) {
        try {
            return field.getDouble(this);
        }
        catch (IllegalAccessException ignored) {
            return annotation.defaultValue();
        }
    }

    private /* synthetic */ void lambda$loadConfig$9(Field field, Options.DoubleField annotation, Double newValue) {
        try {
            field.setDouble(this, newValue);
            this.setConfigOption(annotation.tab() + "." + field.getName(), newValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private /* synthetic */ Double lambda$loadConfig$8(Field field, Options.DoubleField annotation) {
        try {
            return field.getDouble(this);
        }
        catch (IllegalAccessException ignored) {
            return annotation.defaultValue();
        }
    }

    private /* synthetic */ void lambda$loadConfig$7(Field field, Options.FloatField annotation, Float newValue) {
        try {
            field.setFloat(this, newValue.floatValue());
            this.setConfigOption(annotation.tab() + "." + field.getName(), newValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private /* synthetic */ Float lambda$loadConfig$6(Field field, Options.FloatField annotation) {
        try {
            return Float.valueOf(field.getFloat(this));
        }
        catch (IllegalAccessException ignored) {
            return Float.valueOf(annotation.defaultValue());
        }
    }

    private /* synthetic */ void lambda$loadConfig$5(Field field, Options.Integer annotation, Integer newValue) {
        try {
            field.setInt(this, newValue);
            this.setConfigOption(annotation.tab() + "." + field.getName(), newValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private /* synthetic */ Integer lambda$loadConfig$4(Field field, Options.Integer annotation) {
        try {
            return field.getInt(this);
        }
        catch (IllegalAccessException ignored) {
            return annotation.defaultValue();
        }
    }

    private /* synthetic */ void lambda$loadConfig$3(Field field, Options.StringField annotation, String newValue) {
        try {
            field.set(this, newValue);
            this.setConfigOption(annotation.tab() + "." + field.getName(), newValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private /* synthetic */ String lambda$loadConfig$2(Field field, Options.StringField annotation) {
        try {
            return (String)field.get(this);
        }
        catch (IllegalAccessException ignored) {
            return annotation.defaultValue();
        }
    }

    private /* synthetic */ void lambda$loadConfig$1(Field field, Options.Boolean annotation, Boolean newValue) {
        try {
            field.setBoolean(this, newValue);
            this.setConfigOption(annotation.tab() + "." + field.getName(), newValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private /* synthetic */ Boolean lambda$loadConfig$0(Field field, Options.Boolean annotation) {
        try {
            return field.getBoolean(this);
        }
        catch (IllegalAccessException ignored) {
            return annotation.defaultValue();
        }
    }
}

