/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.gui.yacl;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.LongFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.LongSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import me.lortseam.completeconfig.CompleteConfig;
import me.lortseam.completeconfig.data.BooleanEntry;
import me.lortseam.completeconfig.data.BoundedEntry;
import me.lortseam.completeconfig.data.Cluster;
import me.lortseam.completeconfig.data.ColorEntry;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EnumEntry;
import me.lortseam.completeconfig.data.SliderEntry;
import me.lortseam.completeconfig.gui.ConfigScreenBuilder;
import me.lortseam.completeconfig.gui.GuiProvider;
import me.lortseam.completeconfig.gui.yacl.ControllerFunction;
import me.lortseam.completeconfig.gui.yacl.YaclGuiExtension;
import me.lortseam.completeconfig.gui.yacl.controller.ListController;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public final class YaclScreenBuilder
extends ConfigScreenBuilder<ControllerFunction<?>> {
    private static final List<GuiProvider<ControllerFunction<?>>> globalProviders = Lists.newArrayList((Object[])new GuiProvider[]{GuiProvider.create(BooleanEntry.class, entry -> option -> {
        BooleanControllerBuilder builder = BooleanControllerBuilder.create((Option)option);
        entry.getValueFormatter().ifPresent(formatter -> ((BooleanControllerBuilder)builder.valueFormatter(formatter)).coloured(false));
        return builder;
    }, entry -> !entry.isCheckbox(), (Type[])new Type[]{Boolean.TYPE, Boolean.class}), GuiProvider.create(BooleanEntry.class, entry -> option -> TickBoxControllerBuilder.create((Option)option), BooleanEntry::isCheckbox, (Type[])new Type[]{Boolean.TYPE, Boolean.class}), GuiProvider.create(entry -> option -> {
        IntegerFieldControllerBuilder builder = IntegerFieldControllerBuilder.create((Option)option);
        entry.getValueFormatter().ifPresent(arg_0 -> ((IntegerFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Integer.TYPE, Integer.class}), GuiProvider.create(entry -> option -> {
        LongFieldControllerBuilder builder = LongFieldControllerBuilder.create((Option)option);
        entry.getValueFormatter().ifPresent(arg_0 -> ((LongFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Long.TYPE, Long.class}), GuiProvider.create(entry -> option -> {
        FloatFieldControllerBuilder builder = FloatFieldControllerBuilder.create((Option)option);
        entry.getValueFormatter().ifPresent(arg_0 -> ((FloatFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Float.TYPE, Float.class}), GuiProvider.create(entry -> option -> {
        DoubleFieldControllerBuilder builder = DoubleFieldControllerBuilder.create((Option)option);
        entry.getValueFormatter().ifPresent(arg_0 -> ((DoubleFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Double.TYPE, Double.class}), GuiProvider.create(BoundedEntry.class, entry -> option -> {
        IntegerFieldControllerBuilder builder = (IntegerFieldControllerBuilder)((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)((Integer)entry.getMin()))).max((Number)((Integer)entry.getMax()));
        entry.getValueFormatter().ifPresent(arg_0 -> ((IntegerFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Integer.TYPE, Integer.class}), GuiProvider.create(BoundedEntry.class, entry -> option -> {
        LongFieldControllerBuilder builder = (LongFieldControllerBuilder)((LongFieldControllerBuilder)LongFieldControllerBuilder.create((Option)option).min((Number)((Long)entry.getMin()))).max((Number)((Long)entry.getMax()));
        entry.getValueFormatter().ifPresent(arg_0 -> ((LongFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Long.TYPE, Long.class}), GuiProvider.create(BoundedEntry.class, entry -> option -> {
        FloatFieldControllerBuilder builder = (FloatFieldControllerBuilder)((FloatFieldControllerBuilder)FloatFieldControllerBuilder.create((Option)option).min((Number)((Float)entry.getMin()))).max((Number)((Float)entry.getMax()));
        entry.getValueFormatter().ifPresent(arg_0 -> ((FloatFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Float.TYPE, Float.class}), GuiProvider.create(BoundedEntry.class, entry -> option -> {
        DoubleFieldControllerBuilder builder = (DoubleFieldControllerBuilder)((DoubleFieldControllerBuilder)DoubleFieldControllerBuilder.create((Option)option).min((Number)((Double)entry.getMin()))).max((Number)((Double)entry.getMax()));
        entry.getValueFormatter().ifPresent(arg_0 -> ((DoubleFieldControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Double.TYPE, Double.class}), GuiProvider.create(SliderEntry.class, entry -> option -> {
        IntegerSliderControllerBuilder builder = (IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)((Integer)entry.getMin()), (Number)((Integer)entry.getMax()))).step((Number)entry.getInterval().orElse(1));
        entry.getValueFormatter().ifPresent(arg_0 -> ((IntegerSliderControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Integer.TYPE, Integer.class}), GuiProvider.create(SliderEntry.class, entry -> option -> {
        LongSliderControllerBuilder builder = (LongSliderControllerBuilder)((LongSliderControllerBuilder)LongSliderControllerBuilder.create((Option)option).range((Number)((Long)entry.getMin()), (Number)((Long)entry.getMax()))).step((Number)entry.getInterval().orElse(1L));
        entry.getValueFormatter().ifPresent(arg_0 -> ((LongSliderControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Long.TYPE, Long.class}), GuiProvider.create(SliderEntry.class, entry -> option -> {
        FloatSliderControllerBuilder builder = (FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)((Float)entry.getMin()), (Number)((Float)entry.getMax()))).step((Number)entry.getInterval().orElse(Float.valueOf(0.1f)));
        entry.getValueFormatter().ifPresent(arg_0 -> ((FloatSliderControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Float.TYPE, Float.class}), GuiProvider.create(SliderEntry.class, entry -> option -> {
        DoubleSliderControllerBuilder builder = (DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)option).range((Number)((Double)entry.getMin()), (Number)((Double)entry.getMax()))).step((Number)entry.getInterval().orElse(0.01));
        entry.getValueFormatter().ifPresent(arg_0 -> ((DoubleSliderControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[]{Double.TYPE, Double.class}), GuiProvider.create(entry -> option -> StringControllerBuilder.create((Option)option), (Type[])new Type[]{String.class}), GuiProvider.create(EnumEntry.class, entry -> option -> {
        EnumControllerBuilder builder = EnumControllerBuilder.create((Option)option).enumClass(entry.getTypeClass());
        entry.getValueFormatter().ifPresent(arg_0 -> ((EnumControllerBuilder)builder).valueFormatter(arg_0));
        return builder;
    }, (Type[])new Type[0]), GuiProvider.create(ColorEntry.class, entry -> option -> ColorControllerBuilder.create((Option)option).allowAlpha(entry.isAlphaMode()), (Type[])new Type[]{Color.class}), GuiProvider.create(entry -> listOption -> ListController.createBuilder(IntegerFieldControllerBuilder::create), (Type[])new Type[]{new TypeToken<List<Integer>>(){}.getType()}), GuiProvider.create(entry -> listOption -> ListController.createBuilder(LongFieldControllerBuilder::create), (Type[])new Type[]{new TypeToken<List<Long>>(){}.getType()}), GuiProvider.create(entry -> listOption -> ListController.createBuilder(FloatFieldControllerBuilder::create), (Type[])new Type[]{new TypeToken<List<Float>>(){}.getType()}), GuiProvider.create(entry -> listOption -> ListController.createBuilder(DoubleFieldControllerBuilder::create), (Type[])new Type[]{new TypeToken<List<Double>>(){}.getType()}), GuiProvider.create(entry -> listOption -> ListController.createBuilder(StringControllerBuilder::create), (Type[])new Type[]{new TypeToken<List<String>>(){}.getType()})});

    public YaclScreenBuilder() {
        super(globalProviders);
    }

    public class_437 build(class_437 parentScreen, Config config) {
        YetAnotherConfigLib.Builder configBuilder = YetAnotherConfigLib.createBuilder().title(this.getTitle(config)).save(() -> ((Config)config).save());
        if (!config.getEntries().isEmpty()) {
            class_2561 name = config.getClusters().isEmpty() ? this.getTitle(config) : config.getName();
            ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder().name(name);
            for (Entry entry : config.getEntries()) {
                categoryBuilder.option(this.buildOption(entry));
            }
            configBuilder.category(categoryBuilder.build());
        }
        for (Cluster cluster : config.getClusters()) {
            ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder().name(cluster.getName());
            cluster.getDescription().ifPresent(xva$0 -> categoryBuilder.tooltip(new class_2561[]{xva$0}));
            for (Entry entry : cluster.getEntries()) {
                categoryBuilder.option(this.buildOption(entry));
            }
            for (Cluster subCluster : cluster.getClusters()) {
                OptionGroup.Builder groupBuilder = OptionGroup.createBuilder().name(subCluster.getName());
                subCluster.getDescription().ifPresent(description -> groupBuilder.description(OptionDescription.of((class_2561[])new class_2561[]{description})));
                for (Entry entry : subCluster.getEntries()) {
                    groupBuilder.option(this.buildOption(entry));
                }
                if (!subCluster.getClusters().isEmpty()) {
                    throw new UnsupportedOperationException("YACL screen builder doesn't support more than 2 levels of groups");
                }
                categoryBuilder.group(groupBuilder.build());
            }
            configBuilder.category(categoryBuilder.build());
        }
        return configBuilder.build().generateScreen(parentScreen);
    }

    private <T> Option<T> buildOption(Entry<T> entry) {
        Controller parentController = null;
        try {
            parentController = ((ControllerBuilder)((ControllerFunction)this.createEntry(entry)).apply(null)).build();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (parentController instanceof ListController) {
            return this.buildListOption(entry, (ListController)parentController);
        }
        Option.Builder builder = Option.createBuilder().name(entry.getName()).binding(entry.getDefaultValue(), () -> entry.getValue(), arg_0 -> entry.setValue(arg_0)).controller(option -> (ControllerBuilder)((ControllerFunction)this.createEntry(entry)).apply(option));
        entry.getDescription().ifPresent(description -> builder.description(OptionDescription.of((class_2561[])new class_2561[]{description})));
        if (entry.requiresRestart()) {
            builder.flag(new OptionFlag[]{OptionFlag.GAME_RESTART});
        }
        return builder.build();
    }

    private <E, T extends List<E>> Option<T> buildListOption(Entry<T> entry, ListController<E> controller) {
        Class elementClass = (Class)entry.getGenericTypes()[0];
        Object initialValue = controller.getInitialValue();
        if (initialValue == null) {
            if (elementClass == Boolean.class) {
                initialValue = Boolean.FALSE;
            } else if (elementClass == Integer.class) {
                initialValue = 0;
            } else if (elementClass == Long.class) {
                initialValue = 0L;
            } else if (elementClass == Float.class) {
                initialValue = Float.valueOf(0.0f);
            } else if (elementClass == Double.class) {
                initialValue = 0.0;
            } else if (elementClass == String.class) {
                initialValue = "";
            }
        }
        ListOption.Builder builder = ListOption.createBuilder((Class)elementClass).name(entry.getName()).binding((List)entry.getDefaultValue(), () -> entry.getValue(), value -> entry.setValue(value)).controller(controller.getElementControllerBuilder()).initial(initialValue);
        entry.getDescription().ifPresent(description -> builder.description(OptionDescription.of((class_2561[])new class_2561[]{description})));
        if (entry.requiresRestart()) {
            builder.flag(new OptionFlag[]{OptionFlag.GAME_RESTART});
        }
        return builder.build();
    }

    static {
        for (Collection providers : CompleteConfig.collectExtensions(YaclGuiExtension.class, YaclGuiExtension::getProviders)) {
            globalProviders.addAll(providers);
        }
    }
}

