/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.util.mixin;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.melontini.dark_matter.api.base.util.Utilities;
import me.melontini.dark_matter.api.base.util.mixin.AsmUtil;
import me.melontini.dark_matter.api.base.util.mixin.IPluginPlugin;
import me.melontini.dark_matter.api.base.util.mixin.MixinShouldApply;
import me.melontini.dark_matter.api.base.util.mixin.Mod;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;

public final class ShouldApplyPlugin
implements IPluginPlugin {
    private static final String SHOULD_APPLY_DESC = "L" + MixinShouldApply.class.getName().replace(".", "/") + ";";

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName, ClassNode mixinNode, List<AnnotationNode> mergedAnnotations) {
        AnnotationNode node = Annotations.getVisible((ClassNode)mixinNode, MixinShouldApply.class);
        if (node == null) {
            return true;
        }
        Map<String, Object> values = AsmUtil.mapAnnotationNode(node);
        if (values.isEmpty()) {
            return true;
        }
        return ShouldApplyPlugin.checkMods(node) && ShouldApplyPlugin.checkMCVersion(node);
    }

    @Override
    public void afterApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (targetClass.visibleAnnotations != null && !targetClass.visibleAnnotations.isEmpty()) {
            targetClass.visibleAnnotations.removeIf(node -> SHOULD_APPLY_DESC.equals(node.desc));
        }
    }

    private static boolean checkMods(AnnotationNode node) {
        List<Map<String, Object>> array = AsmUtil.getAnnotationValue(node, "mods", AsmUtil.emptyAnnotationList());
        if (array.isEmpty()) {
            return true;
        }
        Iterator<Map<String, Object>> iterator = array.iterator();
        if (iterator.hasNext()) {
            Map<String, Object> map = iterator.next();
            String name = (String)Utilities.cast(map.get("value"));
            Mod.Mode mode = (Mod.Mode)((Object)Utilities.cast(map.getOrDefault("mode", (Object)Mod.Mode.LOADED)));
            return switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Mod.Mode.LOADED -> FabricLoader.getInstance().isModLoaded(name);
                case Mod.Mode.NOT_LOADED -> !FabricLoader.getInstance().isModLoaded(name);
            };
        }
        return true;
    }

    private static boolean checkMCVersion(AnnotationNode node) {
        String version = AsmUtil.getAnnotationValue(node, "mcVersion", "");
        if (version.isEmpty()) {
            return true;
        }
        try {
            VersionPredicate predicate = VersionPredicate.parse((String)version);
            return predicate.test((Object)((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow()).getMetadata().getVersion());
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }
}

