/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.util.mixin;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.melontini.dark_matter.api.base.util.Utilities;
import me.melontini.dark_matter.api.base.util.mixin.AsmUtil;
import me.melontini.dark_matter.api.base.util.mixin.IPluginPlugin;
import me.melontini.dark_matter.api.base.util.mixin.annotations.MixinPredicate;
import me.melontini.dark_matter.api.base.util.mixin.annotations.Mod;
import me.melontini.dark_matter.impl.base.DarkMatterLog;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;

public class MixinPredicatePlugin
implements IPluginPlugin {
    private static final String PREDICATE_DESC = "L" + MixinPredicate.class.getName().replace(".", "/") + ";";

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName, ClassNode mixinNode, List<AnnotationNode> mergedAnnotations) {
        AnnotationNode node = Annotations.getVisible((ClassNode)mixinNode, MixinPredicate.class);
        if (node == null) {
            return true;
        }
        Map<String, Object> values = AsmUtil.mapAnnotationNode(node);
        if (values.isEmpty()) {
            return true;
        }
        return MixinPredicatePlugin.checkMods(values);
    }

    @Override
    public void afterApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (targetClass.visibleAnnotations != null && !targetClass.visibleAnnotations.isEmpty()) {
            targetClass.visibleAnnotations.removeIf(node -> PREDICATE_DESC.equals(node.desc));
        }
    }

    private static boolean checkMods(@NotNull Map<String, Object> values) {
        List array = (List)Utilities.cast(values.getOrDefault("mods", AsmUtil.emptyAnnotationList()));
        if (array.isEmpty()) {
            return true;
        }
        Iterator iterator = array.iterator();
        if (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            try {
                String id = (String)Utilities.cast(map.get("value"));
                Mod.State state = (Mod.State)((Object)Utilities.cast(map.getOrDefault("state", Mod.State.LOADED)));
                String version = (String)Utilities.cast(map.getOrDefault("version", "*"));
                VersionPredicate predicate = VersionPredicate.parse((String)version);
                Optional container = FabricLoader.getInstance().getModContainer(id);
                return switch (state) {
                    default -> throw new IncompatibleClassChangeError();
                    case Mod.State.LOADED -> {
                        boolean b = container.filter(modContainer -> predicate.test((Object)modContainer.getMetadata().getVersion())).isPresent();
                        DarkMatterLog.debug("Checking mod {}. {} ({}): {}", new Object[]{id, state, version, b});
                        yield b;
                    }
                    case Mod.State.NOT_LOADED -> {
                        boolean b = container.map(modContainer -> !predicate.test((Object)modContainer.getMetadata().getVersion())).orElse(true);
                        DarkMatterLog.debug("Checking mod {}. {} ({}): {}", new Object[]{id, state, version, b});
                        yield b;
                    }
                };
            }
            catch (Exception e) {
                DarkMatterLog.error("Error while checking mods", e);
                return true;
            }
        }
        return true;
    }
}

